/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.conformance.MutableObservableSetContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class DetailObservableSetTest
extends AbstractDefaultRealmTestCase {
    public void testElementTypeNull() throws Exception {
        WritableValue observableValue = new WritableValue((Object)new WritableSet(new HashSet(), Object.class), null);
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)observableValue, null);
        DetailObservableSetTest.assertNull((Object)detailObservable.getElementType());
        factory.type = Object.class;
        observableValue.setValue((Object)new WritableSet(Arrays.asList(new Object()), String.class));
        DetailObservableSetTest.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
        factory.type = String.class;
        observableValue.setValue((Object)new WritableSet(Arrays.asList("1"), Object.class));
        DetailObservableSetTest.assertNull((String)"element type not null", (Object)detailObservable.getElementType());
    }

    public void testElementTypeNotNull() throws Exception {
        WritableValue observableValue = new WritableValue((Object)new WritableSet(new HashSet(), Object.class), null);
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)observableValue, Object.class);
        DetailObservableSetTest.assertEquals((Object)factory.type, (Object)detailObservable.getElementType());
        try {
            factory.type = String.class;
            observableValue.setValue((Object)new WritableSet(Arrays.asList(new Object()), String.class));
            DetailObservableSetTest.fail((String)"if an element type is set this cannot be changed");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testMasterNotDisposedWhenDetailDisposed() {
        class OuterObservable
        extends WritableValue {
            boolean disposed = false;

            OuterObservable() {
            }

            public synchronized void dispose() {
                this.disposed = true;
                super.dispose();
            }
        }
        OuterObservable outerObservable = new OuterObservable();
        WritableSetFactory factory = new WritableSetFactory();
        DetailObservableSet detailObservable = new DetailObservableSet((IObservableFactory)factory, (IObservableValue)outerObservable, null);
        DetailObservableSetTest.assertFalse((boolean)outerObservable.disposed);
        detailObservable.dispose();
        DetailObservableSetTest.assertFalse((boolean)outerObservable.disposed);
    }

    public void testDisposeMasterDisposesDetail() {
        WritableValue master = new WritableValue();
        WritableSetFactory factory = new WritableSetFactory();
        master.setValue((Object)"");
        IObservableSet detailObservable = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)factory, null);
        DisposeEventTracker tracker = DisposeEventTracker.observe((IObservable)detailObservable);
        master.dispose();
        DetailObservableSetTest.assertEquals((int)1, (int)tracker.count);
        DetailObservableSetTest.assertTrue((boolean)detailObservable.isDisposed());
    }

    public void testDisposeWhileFiringEvents() {
        WritableValue master = new WritableValue();
        WritableSetFactory factory = new WritableSetFactory();
        master.setValue((Object)"");
        final IObservableSet[] detailObservable = new IObservableSet[1];
        master.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                detailObservable[0].dispose();
            }
        });
        detailObservable[0] = MasterDetailObservables.detailSet((IObservableValue)master, (IObservableFactory)factory, null);
        master.setValue((Object)"New Value");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DetailObservableSetTest.class.getName());
        suite.addTestSuite(DetailObservableSetTest.class);
        suite.addTest(MutableObservableSetContractTest.suite((IObservableCollectionContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableCollectionContractDelegate {
        Object elementType = Object.class;

        Delegate() {
        }

        public IObservableCollection createObservableCollection(Realm realm, int elementCount) {
            WritableValue master = new WritableValue(realm, (Object)elementCount, Integer.class);
            FactoryStub factory = new FactoryStub(realm, this.elementType);
            return new DetailObservableSetStub(factory, (IObservableValue)master, this.elementType);
        }

        public Object createElement(IObservableCollection collection) {
            return new Object();
        }

        public Object getElementType(IObservableCollection collection) {
            return this.elementType;
        }

        public void change(IObservable observable) {
            IObservableValue master = ((DetailObservableSetStub)observable).master;
            master.setValue((Object)((Integer)master.getValue() + 1));
        }
    }

    static class DetailObservableSetStub
    extends DetailObservableSet {
        IObservableValue master;

        DetailObservableSetStub(IObservableFactory factory, IObservableValue master, Object elementType) {
            super(factory, master, elementType);
            this.master = master;
        }
    }

    static class FactoryStub
    implements IObservableFactory {
        private Realm realm;
        private Object elementType;
        Object type = Object.class;

        FactoryStub(Realm realm, Object elementType) {
            this.realm = realm;
            this.elementType = elementType;
        }

        public IObservable createObservable(Object target) {
            int elementCount = (Integer)target;
            HashSet<Object> wrappedSet = new HashSet<Object>();
            int i = 0;
            while (i < elementCount) {
                wrappedSet.add(new Object());
                ++i;
            }
            return new WritableSet(this.realm, wrappedSet, this.elementType);
        }
    }

    private static class WritableSetFactory
    implements IObservableFactory {
        Object type = Object.class;

        private WritableSetFactory() {
        }

        public IObservable createObservable(Object target) {
            return new WritableSet(new HashSet(), this.type);
        }
    }
}

