/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.observable.masterdetail;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.internal.databinding.observable.masterdetail.SetDetailValueObservableMap;
import org.eclipse.jface.databinding.conformance.util.MapChangeEventTracker;
import org.eclipse.jface.examples.databinding.model.SimplePerson;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class SetDetailValueObservableMapTest
extends AbstractDefaultRealmTestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(SetDetailValueObservableMapTest.class.getName());
        suite.addTestSuite(SetDetailValueObservableMapTest.class);
        return suite;
    }

    public void testGetValueType() {
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)new WritableSet(), BeansObservables.valueFactory((String)"name"), String.class);
        SetDetailValueObservableMapTest.assertSame(String.class, (Object)sdom.getValueType());
    }

    public void testGetObserved() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SetDetailValueObservableMapTest.assertSame((Object)masterKeySet, (Object)sdom.getObserved());
    }

    public void testMasterSetInitiallyNotEmpty() {
        WritableSet masterKeySet = new WritableSet();
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterKeySet.add((Object)person);
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SetDetailValueObservableMapTest.assertEquals((int)masterKeySet.size(), (int)sdom.size());
        SetDetailValueObservableMapTest.assertEquals((Object)person.getName(), (Object)sdom.get((Object)person));
    }

    public void testAddRemove() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.isEmpty());
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterKeySet.add((Object)p1);
        SetDetailValueObservableMapTest.assertEquals((int)masterKeySet.size(), (int)sdom.size());
        SetDetailValueObservableMapTest.assertEquals((Object)p1.getName(), (Object)sdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name2");
        masterKeySet.add((Object)p2);
        SetDetailValueObservableMapTest.assertEquals((int)masterKeySet.size(), (int)sdom.size());
        SetDetailValueObservableMapTest.assertEquals((Object)p2.getName(), (Object)sdom.get((Object)p2));
        masterKeySet.remove((Object)p1);
        SetDetailValueObservableMapTest.assertEquals((int)masterKeySet.size(), (int)sdom.size());
        SetDetailValueObservableMapTest.assertEquals((Object)p2.getName(), (Object)sdom.get((Object)p2));
        masterKeySet.remove((Object)p2);
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.isEmpty());
    }

    public void testChangeDetail() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        p1.setName("name1");
        masterKeySet.add((Object)p1);
        SetDetailValueObservableMapTest.assertEquals((Object)p1.getName(), (Object)sdom.get((Object)p1));
        p1.setName("name2");
        SetDetailValueObservableMapTest.assertEquals((Object)p1.getName(), (Object)sdom.get((Object)p1));
        SimplePerson p2 = new SimplePerson();
        p2.setName("name3");
        masterKeySet.add((Object)p2);
        SetDetailValueObservableMapTest.assertEquals((Object)p2.getName(), (Object)sdom.get((Object)p2));
    }

    public void testPut() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name1");
        masterKeySet.add((Object)person);
        SetDetailValueObservableMapTest.assertEquals((Object)person.getName(), (Object)sdom.get((Object)person));
        sdom.put((Object)person, (Object)"name2");
        SetDetailValueObservableMapTest.assertEquals((String)"name2", (String)person.getName());
        SetDetailValueObservableMapTest.assertEquals((Object)person.getName(), (Object)sdom.get((Object)person));
    }

    public void testContainsValue() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson person = new SimplePerson();
        person.setName("name");
        masterKeySet.add((Object)person);
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.containsValue((Object)person.getName()));
        masterKeySet.remove((Object)person);
        SetDetailValueObservableMapTest.assertFalse((boolean)sdom.containsValue((Object)person.getName()));
    }

    public void testRemove() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SimplePerson p1 = new SimplePerson();
        SimplePerson p2 = new SimplePerson();
        masterKeySet.add((Object)p1);
        masterKeySet.add((Object)p2);
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.containsKey((Object)p1));
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.containsKey((Object)p2));
        sdom.remove((Object)p1);
        SetDetailValueObservableMapTest.assertFalse((boolean)sdom.containsKey((Object)p1));
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.containsKey((Object)p2));
        sdom.remove((Object)p1);
        SetDetailValueObservableMapTest.assertFalse((boolean)sdom.containsKey((Object)p1));
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.containsKey((Object)p2));
    }

    public void testDetailObservableChangeEvent() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        MapChangeEventTracker changeTracker = MapChangeEventTracker.observe((IObservableMap)sdom);
        SimplePerson person = new SimplePerson();
        person.setName("old name");
        SetDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.count);
        masterKeySet.add((Object)person);
        SetDetailValueObservableMapTest.assertEquals((int)1, (int)changeTracker.count);
        SetDetailValueObservableMapTest.assertEquals((int)1, (int)changeTracker.event.diff.getAddedKeys().size());
        SetDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getRemovedKeys().size());
        SetDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getChangedKeys().size());
        SetDetailValueObservableMapTest.assertSame((Object)person, changeTracker.event.diff.getAddedKeys().iterator().next());
        SetDetailValueObservableMapTest.assertNull((Object)changeTracker.event.diff.getOldValue((Object)person));
        SetDetailValueObservableMapTest.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getNewValue((Object)person));
        person.setName("new name");
        SetDetailValueObservableMapTest.assertEquals((int)2, (int)changeTracker.count);
        SetDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getAddedKeys().size());
        SetDetailValueObservableMapTest.assertEquals((int)0, (int)changeTracker.event.diff.getRemovedKeys().size());
        SetDetailValueObservableMapTest.assertEquals((int)1, (int)changeTracker.event.diff.getChangedKeys().size());
        SetDetailValueObservableMapTest.assertSame((Object)person, changeTracker.event.diff.getChangedKeys().iterator().next());
        SetDetailValueObservableMapTest.assertEquals((Object)"old name", (Object)changeTracker.event.diff.getOldValue((Object)person));
        SetDetailValueObservableMapTest.assertEquals((Object)"new name", (Object)changeTracker.event.diff.getNewValue((Object)person));
    }

    public void testMasterNull() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        masterKeySet.add(null);
        SetDetailValueObservableMapTest.assertEquals((int)1, (int)sdom.size());
        SetDetailValueObservableMapTest.assertNull((Object)sdom.get(null));
    }

    public void testDetailObservableValuesAreDisposed() {
        final HashMap detailObservables = new HashMap();
        IObservableFactory detailValueFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                WritableValue detailObservable = new WritableValue();
                detailObservables.put(target, detailObservable);
                return detailObservable;
            }
        };
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, detailValueFactory, null);
        Object master1 = new Object();
        Object master2 = new Object();
        masterKeySet.add(master1);
        masterKeySet.add(master2);
        MapChangeEventTracker.observe((IObservableMap)sdom);
        SetDetailValueObservableMapTest.assertEquals((int)sdom.size(), (int)detailObservables.size());
        SetDetailValueObservableMapTest.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        SetDetailValueObservableMapTest.assertFalse((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        masterKeySet.remove(master2);
        SetDetailValueObservableMapTest.assertFalse((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        SetDetailValueObservableMapTest.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
        sdom.dispose();
        SetDetailValueObservableMapTest.assertTrue((boolean)((WritableValue)detailObservables.get(master1)).isDisposed());
        SetDetailValueObservableMapTest.assertTrue((boolean)((WritableValue)detailObservables.get(master2)).isDisposed());
    }

    public void testDisposeOnMasterDisposed() {
        WritableSet masterKeySet = new WritableSet();
        SetDetailValueObservableMap sdom = new SetDetailValueObservableMap((IObservableSet)masterKeySet, BeansObservables.valueFactory((String)"name"), String.class);
        SetDetailValueObservableMapTest.assertFalse((boolean)masterKeySet.isDisposed());
        SetDetailValueObservableMapTest.assertFalse((boolean)sdom.isDisposed());
        masterKeySet.dispose();
        SetDetailValueObservableMapTest.assertTrue((boolean)masterKeySet.isDisposed());
        SetDetailValueObservableMapTest.assertTrue((boolean)sdom.isDisposed());
    }
}

