/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.validation.NumberToNumberValidator;
import org.eclipse.core.runtime.IStatus;

public abstract class NumberToNumberValidatorTestHarness
extends TestCase {
    protected abstract NumberToNumberValidator doGetToPrimitiveValidator(Class var1);

    protected abstract NumberToNumberValidator doGetToBoxedTypeValidator(Class var1);

    protected abstract Number doGetOutOfRangeNumber();

    public void testValidateNullForBoxedTypeIsOK() throws Exception {
        IStatus status = this.doGetToBoxedTypeValidator(Integer.class).validate(null);
        NumberToNumberValidatorTestHarness.assertTrue((boolean)status.isOK());
    }

    public void testValidateNullForPrimitiveThrowsIllegalArgumentException() throws Exception {
        NumberToNumberValidator validator = this.doGetToPrimitiveValidator(Integer.class);
        if (validator == null) {
            return;
        }
        try {
            this.doGetToPrimitiveValidator(Integer.class).validate(null);
            NumberToNumberValidatorTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testValidReturnsOK() throws Exception {
        NumberToNumberValidatorTestHarness.assertTrue((boolean)this.doGetToBoxedTypeValidator(Integer.class).validate((Object)1).isOK());
    }

    public void testOutOfRangeReturnsError() throws Exception {
        Number number = this.doGetOutOfRangeNumber();
        if (number == null) {
            return;
        }
        IStatus status = this.doGetToBoxedTypeValidator(Integer.class).validate((Object)number);
        NumberToNumberValidatorTestHarness.assertEquals((int)4, (int)status.getSeverity());
        NumberToNumberValidatorTestHarness.assertTrue((status.getMessage() != null ? 1 : 0) != 0);
    }

    public void testValidateIncorrectTypeThrowsIllegalArgumentException() throws Exception {
        try {
            this.doGetToBoxedTypeValidator(Integer.class).validate((Object)"");
            NumberToNumberValidatorTestHarness.fail((String)"exception should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

