/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.databinding.validation;

import junit.framework.TestCase;
import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;
import org.eclipse.core.internal.databinding.validation.StringToCharacterValidator;

public class StringToCharacterValidatorTest
extends TestCase {
    private StringToCharacterValidator validator;
    private StringToCharacterValidator primitiveValidator;

    protected void setUp() throws Exception {
        super.setUp();
        StringToCharacterConverter converter = StringToCharacterConverter.toCharacter((boolean)false);
        StringToCharacterConverter primitiveConverter = StringToCharacterConverter.toCharacter((boolean)true);
        this.validator = new StringToCharacterValidator(converter);
        this.primitiveValidator = new StringToCharacterValidator(primitiveConverter);
    }

    public void testValidatesCharacter() throws Exception {
        StringToCharacterValidatorTest.assertTrue((boolean)this.validator.validate((Object)"X").isOK());
    }

    public void testValidatesCharacterPrimitive() throws Exception {
        StringToCharacterValidatorTest.assertTrue((boolean)this.primitiveValidator.validate((Object)"X").isOK());
    }

    public void testNullCharacterIsValid() throws Exception {
        StringToCharacterValidatorTest.assertTrue((boolean)this.validator.validate(null).isOK());
    }

    public void testEmptyStringCharacterIsValid() throws Exception {
        StringToCharacterValidatorTest.assertTrue((boolean)this.validator.validate((Object)"").isOK());
    }

    public void testNullCharacterIsInvalidForPrimitive() throws Exception {
        StringToCharacterValidatorTest.assertFalse((boolean)this.primitiveValidator.validate(null).isOK());
    }

    public void testNonStringIsInvalid() throws Exception {
        StringToCharacterValidatorTest.assertFalse((boolean)this.primitiveValidator.validate((Object)4).isOK());
    }

    public void testLongerThanOneCharacterIsInvalid() throws Exception {
        StringToCharacterValidatorTest.assertFalse((boolean)this.primitiveValidator.validate((Object)"XYZ").isOK());
    }
}

