/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.Catalog;
import org.eclipse.jface.examples.databinding.model.Lodging;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ComboScenarios
extends ScenariosTestCase {
    protected ComboViewer cviewer = null;
    protected Combo combo = null;
    protected Catalog catalog = null;
    ILabelProvider lodgingLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((Lodging)element).getName();
        }
    };
    ILabelProvider accountLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            return ((Account)element).getCountry();
        }
    };

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.combo = new Combo(this.getComposite(), 12);
        this.cviewer = new ComboViewer(this.combo);
        this.catalog = SampleData.CATALOG_2005;
    }

    @Override
    protected void tearDown() throws Exception {
        this.combo.dispose();
        this.combo = null;
        this.cviewer = null;
        super.tearDown();
    }

    protected Object getViewerSelection() {
        return this.cviewer.getStructuredSelection().getFirstElement();
    }

    protected List getViewerContent(ComboViewer cviewer) {
        Object[] elements = ((IStructuredContentProvider)cviewer.getContentProvider()).getElements(null);
        if (elements != null) {
            return Arrays.asList(elements);
        }
        return null;
    }

    protected List getComboContent() {
        String[] elements = this.combo.getItems();
        if (elements != null) {
            return Arrays.asList(elements);
        }
        return null;
    }

    protected List getColumn(Object[] list, String feature) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (list == null || list.length == 0) {
            return result;
        }
        String getterName = "get" + feature.substring(0, 1).toUpperCase(Locale.ENGLISH) + feature.substring(1);
        try {
            Method getter = list[0].getClass().getMethod(getterName, new Class[0]);
            try {
                int i = 0;
                while (i < list.length) {
                    result.add(getter.invoke(list[i], new Object[0]));
                    ++i;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return result;
    }

    public void test_ROCombo_Scenario03_vanilla() {
        IObservableList lodgings = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.catalog, (String)"lodgings");
        ViewerSupport.bind((StructuredViewer)this.cviewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        Adventure skiAdventure = SampleData.WINTER_HOLIDAY;
        this.assertArrayEquals(this.catalog.getLodgings(), this.getViewerContent(this.cviewer).toArray());
        ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        this.getDbc().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.cviewer), BeansObservables.observeValue((Object)skiAdventure, (String)"defaultLodging"));
        ComboScenarios.assertEquals((Object)this.getViewerSelection(), (Object)skiAdventure.getDefaultLodging());
        int i = 0;
        while (i < this.catalog.getLodgings().length) {
            Lodging selection = this.catalog.getLodgings()[i];
            this.cviewer.setSelection((ISelection)new StructuredSelection((Object)selection));
            ComboScenarios.assertEquals((Object)selection, (Object)skiAdventure.getDefaultLodging());
            ComboScenarios.assertEquals((Object)this.getViewerSelection(), (Object)skiAdventure.getDefaultLodging());
            ++i;
        }
    }

    public void test_ROCombo_Scenario03_collectionBindings() {
        IObservableList lodgings = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.catalog, (String)"lodgings");
        ViewerSupport.bind((StructuredViewer)this.cviewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        this.assertArrayEquals(this.catalog.getLodgings(), this.getViewerContent(this.cviewer).toArray());
        ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        Lodging lodging = SampleData.FACTORY.createLodging();
        lodging.setName("End Lodging");
        this.catalog.addLodging(lodging);
        int index = this.getComboContent().size() - 1;
        ComboScenarios.assertEquals(this.getViewerContent(this.cviewer).get(index), (Object)lodging);
        this.catalog.removeLodging(this.catalog.getLodgings()[0]);
        ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        this.catalog.removeLodging(this.catalog.getLodgings()[2]);
        ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        int i = 0;
        while (i < this.catalog.getLodgings().length) {
            Lodging l = this.catalog.getLodgings()[i];
            l.setName("Changed: " + l.getName());
            ++i;
        }
        this.spinEventLoop(0);
        ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        Lodging l = this.catalog.getLodgings()[0];
        ComboScenarios.assertEquals((String)this.combo.getItem(0), (String)l.getName());
        l.setName(null);
        ComboScenarios.assertEquals((String)"", (String)this.combo.getItem(0));
        while (this.catalog.getLodgings().length > 0) {
            this.catalog.removeLodging(this.catalog.getLodgings()[0]);
            ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        }
    }

    public void test_ROCombo_multipleBindings() {
        Adventure skiAdventure = SampleData.WINTER_HOLIDAY;
        IObservableList lodgings = BeansObservables.observeList((Realm)Realm.getDefault(), (Object)this.catalog, (String)"lodgings");
        ViewerSupport.bind((StructuredViewer)this.cviewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        this.assertArrayEquals(this.catalog.getLodgings(), this.getViewerContent(this.cviewer).toArray());
        ComboScenarios.assertEquals((Object)this.getColumn(this.catalog.getLodgings(), "name"), (Object)this.getComboContent());
        ComboViewer otherViewer = new ComboViewer(this.getComposite(), 0);
        ViewerSupport.bind((StructuredViewer)otherViewer, (IObservableList)lodgings, (IValueProperty)BeanProperties.value(Lodging.class, (String)"name"));
        this.assertArrayEquals(this.catalog.getLodgings(), this.getViewerContent(otherViewer).toArray());
        IViewerObservableValue selection = ViewersObservables.observeSingleSelection((Viewer)this.cviewer);
        this.getDbc().bindValue((IObservableValue)selection, BeansObservables.observeValue((Object)skiAdventure, (String)"defaultLodging"));
        IViewerObservableValue otherSelection = ViewersObservables.observeSingleSelection((Viewer)otherViewer);
        this.getDbc().bindValue((IObservableValue)otherSelection, BeansObservables.observeValue((Object)skiAdventure, (String)"defaultLodging"));
        Lodging lodging = this.catalog.getLodgings()[0];
        this.cviewer.setSelection((ISelection)new StructuredSelection((Object)lodging));
        ComboScenarios.assertEquals((Object)this.cviewer.getStructuredSelection().getFirstElement(), (Object)otherViewer.getStructuredSelection().getFirstElement());
        this.catalog.removeLodging(lodging);
        ComboScenarios.assertEquals((Object)this.getViewerContent(this.cviewer), (Object)this.getViewerContent(otherViewer));
    }

    public void test_ROCombo_SWTCCombo() {
        WritableList list = new WritableList();
        int i = 0;
        while (i < this.catalog.getAccounts().length) {
            list.add((Object)this.catalog.getAccounts()[i].getCountry());
            ++i;
        }
        CCombo ccombo = new CCombo(this.getComposite(), 12);
        this.getDbc().bindList(SWTObservables.observeItems((Control)ccombo), (IObservableList)list);
        ComboScenarios.assertEquals(Arrays.asList(ccombo.getItems()), (Object)list);
        Account account = this.catalog.getAccounts()[0];
        ISWTObservableValue comboSelection = SWTObservables.observeSelection((Control)ccombo);
        this.getDbc().bindValue((IObservableValue)comboSelection, BeansObservables.observeValue((Object)account, (String)"country"));
        String selection = (String)list.get(2);
        ccombo.setText(selection);
        ComboScenarios.assertEquals((String)account.getCountry(), (String)selection);
    }

    public void test_WCombo_SWTCCombo() {
        WritableList list = new WritableList();
        int i = 0;
        while (i < this.catalog.getAccounts().length) {
            list.add((Object)this.catalog.getAccounts()[i].getCountry());
            ++i;
        }
        CCombo ccombo = new CCombo(this.getComposite(), 12);
        this.getDbc().bindList(SWTObservables.observeItems((Control)ccombo), (IObservableList)list);
        ComboScenarios.assertEquals(Arrays.asList(ccombo.getItems()), (Object)list);
        Account account = this.catalog.getAccounts()[0];
        ISWTObservableValue comboSelection = SWTObservables.observeSelection((Control)ccombo);
        this.getDbc().bindValue((IObservableValue)comboSelection, BeansObservables.observeValue((Object)account, (String)"country"));
        String selection = (String)list.get(2);
        ccombo.setText(selection);
        ComboScenarios.assertEquals((String)account.getCountry(), (String)selection);
        selection = (String)list.get(1);
        account.setCountry(selection);
        ComboScenarios.assertEquals((String)selection, (String)ccombo.getItem(ccombo.getSelectionIndex()));
        ComboScenarios.assertEquals((String)selection, (String)ccombo.getText());
        selection = "country not in list";
        account.setCountry(selection);
        ComboScenarios.assertEquals((int)-1, (int)ccombo.getSelectionIndex());
        ComboScenarios.assertEquals((String)selection, (String)ccombo.getText());
    }

    public void test_ROCombo_SWTList() {
        WritableList list = new WritableList();
        int i = 0;
        while (i < this.catalog.getAccounts().length) {
            list.add((Object)this.catalog.getAccounts()[i].getCountry());
            ++i;
        }
        org.eclipse.swt.widgets.List swtlist = new org.eclipse.swt.widgets.List(this.getComposite(), 12);
        this.getDbc().bindList(SWTObservables.observeItems((Control)swtlist), (IObservableList)list);
        ComboScenarios.assertEquals(Arrays.asList(swtlist.getItems()), (Object)list);
        Account account = this.catalog.getAccounts()[0];
        ISWTObservableValue listSelection = SWTObservables.observeSelection((Control)swtlist);
        this.getDbc().bindValue((IObservableValue)listSelection, BeansObservables.observeValue((Object)account, (String)"country"));
        String selection = (String)list.get(2);
        swtlist.select(2);
        swtlist.notifyListeners(13, null);
        ComboScenarios.assertEquals((String)account.getCountry(), (String)selection);
    }
}

