/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.lang.reflect.Method;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.tests.databinding.scenarios.CustomBeanModelType;

public class CustomBeanUpdateValueStrategy
extends UpdateValueStrategy {
    public IConverter createConverter(Object fromType, Object toType) {
        CustomBeanModelType customBeanModelType;
        if (fromType instanceof CustomBeanModelType) {
            customBeanModelType = (CustomBeanModelType)fromType;
            fromType = customBeanModelType.getType();
        }
        if (toType instanceof CustomBeanModelType) {
            customBeanModelType = (CustomBeanModelType)toType;
            toType = customBeanModelType.getType();
        }
        return super.createConverter(fromType, toType);
    }

    protected void fillDefaults(IObservableValue source, IObservableValue destination) {
        if (destination.getValueType() instanceof CustomBeanModelType && this.beforeSetValidator == null) {
            CustomBeanModelType property = (CustomBeanModelType)destination.getValueType();
            String propertyName = property.getPropertyName();
            String getValidatorMethodName = "get" + this.upperCaseFirstLetter(propertyName) + "Validator";
            Class<?> objectClass = property.getObject().getClass();
            try {
                Method getValidator = objectClass.getMethod(getValidatorMethodName, Class.class);
                this.beforeSetValidator = (IValidator)getValidator.invoke(property.getObject(), new Object[0]);
            }
            catch (Exception exception) {}
        }
        super.fillDefaults(source, destination);
    }

    private String upperCaseFirstLetter(String name) {
        String result = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return result;
    }

    public Boolean isAssignableFromTo(Object fromType, Object toType) {
        if (fromType instanceof CustomBeanModelType) {
            fromType = ((CustomBeanModelType)fromType).getType();
        }
        if (toType instanceof CustomBeanModelType) {
            toType = ((CustomBeanModelType)toType).getType();
        }
        return super.isAssignableFromTo(fromType, toType);
    }
}

