/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.PriceModelObject;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;

public class CustomConverterScenarios
extends ScenariosTestCase {
    private Adventure skiTrip;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.skiTrip = SampleData.WINTER_HOLIDAY;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testScenario01() {
        DataBindingContext dbc = this.getDbc();
        Spinner spinner_dollars = new Spinner(this.getComposite(), 0);
        spinner_dollars.setMaximum(10000);
        Spinner spinner_cents = new Spinner(this.getComposite(), 0);
        PriceModelObject priceModel = new PriceModelObject();
        dbc.bindValue(BeansObservables.observeValue((Object)priceModel, (String)"price"), BeansObservables.observeValue((Object)this.skiTrip, (String)"price"));
        dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)spinner_dollars), BeansObservables.observeValue((Object)priceModel, (String)"dollars"));
        dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)spinner_cents), BeansObservables.observeValue((Object)priceModel, (String)"cents"));
        CustomConverterScenarios.assertEquals((int)spinner_dollars.getSelection(), (int)new Double(this.skiTrip.getPrice()).intValue());
        Double doublePrice = new Double(this.skiTrip.getPrice());
        double cents = 100.0 * doublePrice - (double)(100 * doublePrice.intValue());
        CustomConverterScenarios.assertEquals((int)spinner_cents.getSelection(), (int)((int)cents));
        spinner_dollars.setSelection(50);
        double expectedPrice = 50.0 + cents / 100.0;
        CustomConverterScenarios.assertEquals((double)expectedPrice, (double)this.skiTrip.getPrice(), (double)0.01);
        spinner_cents.setSelection(27);
        CustomConverterScenarios.assertEquals((double)50.27, (double)this.skiTrip.getPrice(), (double)0.01);
        this.skiTrip.setPrice(60.99);
        CustomConverterScenarios.assertEquals((int)60, (int)spinner_dollars.getSelection());
        CustomConverterScenarios.assertEquals((int)99, (int)spinner_cents.getSelection());
    }
}

