/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import com.ibm.icu.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.Cart;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class PropertyScenarios
extends ScenariosTestCase {
    private Adventure adventure;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.adventure = SampleData.WINTER_HOLIDAY;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEnterText() {
        Text text = new Text(this.getComposite(), 2048);
        final boolean[] focusLostHolder = new boolean[1];
        text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                focusLostHolder[0] = true;
            }
        });
        this.enterText(text, "hallo");
        PropertyScenarios.assertTrue((boolean)focusLostHolder[0]);
    }

    public void testScenario01() {
        Text text = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        PropertyScenarios.assertEquals((String)this.adventure.getName(), (String)text.getText());
        this.enterText(text, "foobar");
        PropertyScenarios.assertEquals((String)"foobar", (String)this.adventure.getName());
        this.adventure.setName("barfoo");
        PropertyScenarios.assertEquals((String)"barfoo", (String)text.getText());
    }

    public void testScenario02() {
        Text text = new Text(this.getComposite(), 8);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)0), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        PropertyScenarios.assertEquals((String)this.adventure.getName(), (String)text.getText());
    }

    public void testScenario03() {
        Cart cart = SampleData.CART;
        cart.setAdventureDays(42);
        Text text = new Text(this.getComposite(), 2048);
        System.out.println("Expecting message about not being able to attach a listener");
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)cart, (String)"lodgingDays"));
        PropertyScenarios.assertEquals((String)Integer.valueOf(cart.getLodgingDays()).toString(), (String)text.getText());
    }

    public void testScenario04() {
        Text text = new Text(this.getComposite(), 2048);
        IObservableValue defaultLodging = BeansObservables.observeDetailValue((IObservableValue)BeansObservables.observeValue((Object)this.adventure, (String)"defaultLodging"), (String)"description", String.class);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), defaultLodging);
        PropertyScenarios.assertEquals((String)this.adventure.getDefaultLodging().getDescription(), (String)text.getText());
        this.enterText(text, "foobar");
        PropertyScenarios.assertEquals((String)"foobar", (String)this.adventure.getDefaultLodging().getDescription());
        this.adventure.getDefaultLodging().setDescription("barfoo");
        PropertyScenarios.assertEquals((String)this.adventure.getDefaultLodging().getDescription(), (String)text.getText());
        this.adventure.setDefaultLodging(SampleData.CAMP_GROUND);
        PropertyScenarios.assertEquals((String)this.adventure.getDefaultLodging().getDescription(), (String)text.getText());
        this.adventure.getDefaultLodging().setDescription("barfo");
        PropertyScenarios.assertEquals((String)this.adventure.getDefaultLodging().getDescription(), (String)text.getText());
        this.adventure.setDefaultLodging(null);
        PropertyScenarios.assertEquals((String)"", (String)text.getText());
        this.adventure.setDefaultLodging(SampleData.FIVE_STAR_HOTEL);
        PropertyScenarios.assertEquals((String)this.adventure.getDefaultLodging().getDescription(), (String)text.getText());
        this.adventure.getDefaultLodging().setDescription("barf");
        PropertyScenarios.assertEquals((String)this.adventure.getDefaultLodging().getDescription(), (String)text.getText());
    }

    public void testScenario05() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setName("UPPERCASE");
        IConverter converter1 = new IConverter(){

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }

            public Object convert(Object toObject) {
                String modelValue = (String)toObject;
                if (modelValue == null || modelValue.equals("")) {
                    return modelValue;
                }
                String firstChar = modelValue.substring(0, 1);
                String remainingChars = modelValue.substring(1);
                return String.valueOf(firstChar.toUpperCase()) + remainingChars.toLowerCase();
            }
        };
        IConverter converter2 = new IConverter(){

            public Object getFromType() {
                return String.class;
            }

            public Object getToType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                return ((String)fromObject).toUpperCase();
            }
        };
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"), new UpdateValueStrategy().setConverter(converter2), new UpdateValueStrategy().setConverter(converter1));
        PropertyScenarios.assertEquals((String)"Uppercase", (String)text.getText());
        this.enterText(text, "lowercase");
        PropertyScenarios.assertEquals((String)"LOWERCASE", (String)this.adventure.getName());
    }

    public void testScenario06() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setName("ValidValue");
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                String stringValue = (String)value;
                if (stringValue.length() > 15) {
                    return ValidationStatus.error((String)"Maximum length for name is 15 characters.");
                }
                if (stringValue.indexOf(32) != -1) {
                    return ValidationStatus.cancel((String)"Name must not contain spaces.");
                }
                return Status.OK_STATUS;
            }
        };
        Binding binding = this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"), new UpdateValueStrategy().setConverter((IConverter)new IdentityConverter(String.class)).setAfterGetValidator(validator), new UpdateValueStrategy().setConverter((IConverter)new IdentityConverter(String.class)));
        PropertyScenarios.assertTrue((boolean)((IStatus)binding.getValidationStatus().getValue()).isOK());
        this.enterText(text, "Invalid Value");
        PropertyScenarios.assertEquals((String)"Name must not contain spaces.", (String)((IStatus)binding.getValidationStatus().getValue()).getMessage());
        PropertyScenarios.assertEquals((String)"ValidValue", (String)this.adventure.getName());
        text.setText("InvalidValueBecauseTooLong");
        PropertyScenarios.assertEquals((String)"Maximum length for name is 15 characters.", (String)((IStatus)binding.getValidationStatus().getValue()).getMessage());
        PropertyScenarios.assertEquals((String)"ValidValue", (String)this.adventure.getName());
        this.enterText(text, "anothervalid");
        PropertyScenarios.assertTrue((boolean)((IStatus)binding.getValidationStatus().getValue()).isOK());
        PropertyScenarios.assertEquals((String)"anothervalid", (String)this.adventure.getName());
    }

    public void testScenario07() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setPrice(5.0);
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                String stringValue = (String)value;
                try {
                    double doubleValue = new Double(stringValue);
                    if (doubleValue < 0.0) {
                        return ValidationStatus.error((String)"Price cannot be negative.");
                    }
                    return Status.OK_STATUS;
                }
                catch (NumberFormatException numberFormatException) {
                    return ValidationStatus.error((String)"Price must be a currency.");
                }
            }
        };
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumFractionDigits(1);
        StringToNumberConverter targetToModelConverter = StringToNumberConverter.toDouble((NumberFormat)numberFormat, (boolean)true);
        NumberToStringConverter modelToTargetConverter = NumberToStringConverter.fromDouble((NumberFormat)numberFormat, (boolean)true);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"price"), new UpdateValueStrategy().setAfterGetValidator(validator).setConverter((IConverter)targetToModelConverter), new UpdateValueStrategy().setConverter((IConverter)modelToTargetConverter));
        String expected = numberFormat.format(this.adventure.getPrice());
        PropertyScenarios.assertEquals((String)expected, (String)text.getText());
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        String toEnter = numberFormat.format(0.65);
        this.enterText(text, toEnter);
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        PropertyScenarios.assertEquals((double)0.65, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(42.24);
        expected = numberFormat.format(this.adventure.getPrice());
        PropertyScenarios.assertEquals((String)expected, (String)text.getText());
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        this.enterText(text, "jygt");
        PropertyScenarios.assertEquals((String)"Price must be a currency.", (String)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        toEnter = numberFormat.format(-23.9);
        this.enterText(text, toEnter);
        PropertyScenarios.assertEquals((String)"Price cannot be negative.", (String)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        PropertyScenarios.assertEquals((double)42.24, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(0.0);
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
    }

    public void testScenario08() {
        Text text = new Text(this.getComposite(), 2048);
        this.adventure.setPrice(5.0);
        final NumberFormat currencyFormat = NumberFormat.getCurrencyInstance((Locale)Locale.CANADA);
        Converter toCurrency = new Converter(Double.TYPE, String.class){

            public Object convert(Object toObject) {
                return currencyFormat.format(((Double)toObject).doubleValue());
            }
        };
        Converter toDouble = new Converter(String.class, Double.TYPE){

            public Object convert(Object fromObject) {
                try {
                    return new Double(currencyFormat.parse((String)fromObject).doubleValue());
                }
                catch (ParseException parseException) {
                    return new Double(0.0);
                }
            }
        };
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                String stringValue = (String)value;
                try {
                    double doubleValue = currencyFormat.parse(stringValue).doubleValue();
                    if (doubleValue < 0.0) {
                        return ValidationStatus.error((String)"Price cannot be negative.");
                    }
                    return Status.OK_STATUS;
                }
                catch (ParseException parseException) {
                    return ValidationStatus.error((String)"Price must be a currency.");
                }
            }
        };
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"price"), new UpdateValueStrategy().setConverter((IConverter)toDouble).setAfterGetValidator(validator), new UpdateValueStrategy().setConverter((IConverter)toCurrency));
        String expected = currencyFormat.format(5L);
        PropertyScenarios.assertEquals((String)expected, (String)text.getText());
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        String toEnter = currencyFormat.format(0.65);
        this.enterText(text, toEnter);
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        PropertyScenarios.assertEquals((double)0.65, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(42.24);
        expected = currencyFormat.format(this.adventure.getPrice());
        PropertyScenarios.assertEquals((String)expected, (String)text.getText());
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
        this.enterText(text, "jygt");
        PropertyScenarios.assertEquals((String)"Price must be a currency.", (String)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        toEnter = currencyFormat.format(-23.9);
        this.enterText(text, toEnter);
        PropertyScenarios.assertEquals((String)"Price cannot be negative.", (String)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).getMessage());
        PropertyScenarios.assertEquals((double)42.24, (double)this.adventure.getPrice(), (double)1.0E-4);
        this.adventure.setPrice(0.0);
        PropertyScenarios.assertTrue((boolean)AggregateValidationStatus.getStatusMaxSeverity((Collection)this.getDbc().getBindings()).isOK());
    }

    public void testScenario09() {
        Button checkbox = new Button(this.getComposite(), 32);
        this.adventure.setPetsAllowed(true);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeSelection((Control)checkbox), BeansObservables.observeValue((Object)this.adventure, (String)"petsAllowed"));
        PropertyScenarios.assertEquals((boolean)true, (boolean)checkbox.getSelection());
        this.setButtonSelectionWithEvents(checkbox, false);
        PropertyScenarios.assertEquals((boolean)false, (boolean)this.adventure.isPetsAllowed());
        this.adventure.setPetsAllowed(true);
        PropertyScenarios.assertEquals((boolean)true, (boolean)checkbox.getSelection());
    }

    public void testScenario10() {
    }

    public void testScenario11() {
        Spinner spinner1 = new Spinner(this.getComposite(), 0);
        spinner1.setSelection(10);
        spinner1.setMinimum(1);
        spinner1.setMaximum(100);
        Spinner spinner2 = new Spinner(this.getComposite(), 0);
        spinner2.setMaximum(1);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeSelection((Control)spinner1), (IObservableValue)SWTObservables.observeMax((Control)spinner2));
        PropertyScenarios.assertEquals((int)1, (int)spinner1.getSelection());
        spinner1.setSelection(10);
        spinner1.notifyListeners(24, new Event());
        PropertyScenarios.assertEquals((int)10, (int)spinner2.getMaximum());
    }

    public void testScenario12() {
        Button checkbox1 = new Button(this.getComposite(), 32);
        checkbox1.setSelection(false);
        Button checkbox2 = new Button(this.getComposite(), 32);
        checkbox2.setSelection(false);
        Text text1 = new Text(this.getComposite(), 0);
        Text text2 = new Text(this.getComposite(), 0);
        ISWTObservableValue checkbox1Selected = SWTObservables.observeSelection((Control)checkbox1);
        ISWTObservableValue checkbox2Selected = SWTObservables.observeSelection((Control)checkbox2);
        Converter negatingConverter = new Converter(Boolean.TYPE, Boolean.TYPE){

            private Boolean negated(Boolean booleanObject) {
                return booleanObject == false;
            }

            public Object convert(Object targetObject) {
                return this.negated((Boolean)targetObject);
            }
        };
        this.getDbc().bindValue((IObservableValue)checkbox1Selected, (IObservableValue)checkbox2Selected, new UpdateValueStrategy().setConverter((IConverter)negatingConverter), new UpdateValueStrategy().setConverter((IConverter)negatingConverter));
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)text1), (IObservableValue)checkbox1Selected);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)text2), (IObservableValue)checkbox2Selected);
        PropertyScenarios.assertEquals((boolean)true, (boolean)text1.getEnabled());
        PropertyScenarios.assertEquals((boolean)false, (boolean)text2.getEnabled());
        PropertyScenarios.assertEquals((boolean)true, (boolean)checkbox1.getSelection());
        this.setButtonSelectionWithEvents(checkbox1, false);
        PropertyScenarios.assertEquals((boolean)false, (boolean)text1.getEnabled());
        PropertyScenarios.assertEquals((boolean)true, (boolean)text2.getEnabled());
        PropertyScenarios.assertEquals((boolean)true, (boolean)checkbox2.getSelection());
        this.setButtonSelectionWithEvents(checkbox2, false);
        PropertyScenarios.assertEquals((boolean)true, (boolean)text1.getEnabled());
        PropertyScenarios.assertEquals((boolean)false, (boolean)text2.getEnabled());
        PropertyScenarios.assertEquals((boolean)true, (boolean)checkbox1.getSelection());
    }

    public void testScenario13() {
        Text text = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)16), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        String adventureName = this.adventure.getName();
        PropertyScenarios.assertEquals((String)adventureName, (String)text.getText());
        this.enterText(text, "foobar");
        PropertyScenarios.assertEquals((String)"foobar", (String)this.adventure.getName());
        this.adventure.setName("barfoo");
        PropertyScenarios.assertEquals((String)"barfoo", (String)text.getText());
    }

    public void testScenario14() {
        Text t1 = new Text(this.getComposite(), 2048);
        Text t2 = new Text(this.getComposite(), 2048);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)t1, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)t2, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        final int[] counter = new int[1];
        IObservableValue uv = BeansObservables.observeValue((Object)this.adventure, (String)"name");
        uv.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                counter[0] = counter[0] + 1;
            }
        });
        String name = String.valueOf(this.adventure.getName()) + "Foo";
        this.enterText(t1, name);
        PropertyScenarios.assertEquals((String)name, (String)this.adventure.getName());
        PropertyScenarios.assertEquals((String)name, (String)t2.getText());
        PropertyScenarios.assertTrue((counter[0] == 1 ? 1 : 0) != 0);
        name = String.valueOf(name) + "Bar";
        uv.setValue((Object)name);
        PropertyScenarios.assertEquals((String)t1.getText(), (String)this.adventure.getName());
        PropertyScenarios.assertEquals((int)2, (int)counter[0]);
    }

    public void testScenario15() {
        Text text = new Text(this.getComposite(), 0);
        Account account = new Account();
        account.setExpiryDate(new Date());
        Binding b = this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), BeansObservables.observeValue((Object)account, (String)"expiryDate"));
        Text errorText = new Text(this.getComposite(), 0);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)errorText, (int)24), b.getValidationStatus(), new UpdateValueStrategy(false, UpdateValueStrategy.POLICY_NEVER), null);
        PropertyScenarios.assertTrue((boolean)((IStatus)b.getValidationStatus().getValue()).isOK());
        this.enterText(text, "foo");
        PropertyScenarios.assertFalse((boolean)((IStatus)b.getValidationStatus().getValue()).isOK());
    }
}

