/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Catalog;
import org.eclipse.jface.examples.databinding.model.Category;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TableScenarios
extends ScenariosTestCase {
    private TableViewer tableViewer;
    private Catalog catalog;
    Category category;
    private TableColumn firstNameColumn;
    private TableColumn lastNameColumn;
    private TableColumn stateColumn;
    Image[] images;
    private TableColumn fancyColumn;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getComposite().setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer(this.getComposite());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.firstNameColumn = new TableColumn(this.tableViewer.getTable(), 0);
        this.firstNameColumn.setWidth(50);
        this.lastNameColumn = new TableColumn(this.tableViewer.getTable(), 0);
        this.lastNameColumn.setWidth(50);
        this.stateColumn = new TableColumn(this.tableViewer.getTable(), 0);
        this.stateColumn.setWidth(50);
        this.fancyColumn = new TableColumn(this.tableViewer.getTable(), 0);
        this.fancyColumn.setWidth(250);
        this.catalog = SampleData.CATALOG_2005;
        this.category = SampleData.WINTER_CATEGORY;
        this.images = new Image[]{this.getShell().getDisplay().getSystemImage(1), this.getShell().getDisplay().getSystemImage(8), this.getShell().getDisplay().getSystemImage(2)};
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.tableViewer.getTable().dispose();
        this.tableViewer = null;
        this.firstNameColumn = null;
        this.lastNameColumn = null;
        this.stateColumn = null;
    }

    public void testScenario01() {
        Account[] accounts = this.catalog.getAccounts();
        WritableList list = new WritableList(new ArrayList(), Account.class);
        list.addAll(Arrays.asList(accounts));
        ViewerSupport.bind((StructuredViewer)this.tableViewer, (IObservableList)list, (IValueProperty[])BeanProperties.values(Account.class, (String[])new String[]{"firstName", "lastName", "state"}));
        Table table = this.tableViewer.getTable();
        int i = 0;
        while (i < accounts.length) {
            Account account = this.catalog.getAccounts()[i];
            TableItem item = table.getItem(i);
            TableScenarios.assertEquals((String)account.getFirstName(), (String)item.getText(0));
            TableScenarios.assertEquals((String)account.getLastName(), (String)item.getText(1));
            TableScenarios.assertEquals((String)account.getState(), (String)item.getText(2));
            ++i;
        }
    }

    public void testScenario02() throws SecurityException, IllegalArgumentException {
    }

    public void testScenario04() {
    }

    public void testScenario03() {
    }

    public void testScenario05() {
    }

    public void testScenario06() {
    }

    public void testScenario07() {
    }

    public void testScenario08_00() {
    }

    public void testScenario08_01() {
    }

    public void testScenario09() {
    }
}

