/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.scenarios;

import com.ibm.icu.text.NumberFormat;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.examples.databinding.model.Account;
import org.eclipse.jface.examples.databinding.model.Adventure;
import org.eclipse.jface.examples.databinding.model.SampleData;
import org.eclipse.jface.examples.databinding.model.Transportation;
import org.eclipse.jface.tests.databinding.BindingTestSuite;
import org.eclipse.jface.tests.databinding.scenarios.CustomBeanUpdateValueStrategy;
import org.eclipse.jface.tests.databinding.scenarios.ScenariosTestCase;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextControlScenario
extends ScenariosTestCase {
    private Text text;
    private Adventure adventure;
    private Transportation transportation;
    Account account;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.adventure = SampleData.WINTER_HOLIDAY;
        this.transportation = SampleData.EXECUTIVE_JET;
        this.account = SampleData.PRESIDENT;
        this.text = new Text(this.getComposite(), 2048);
    }

    @Override
    protected void tearDown() throws Exception {
        this.text.dispose();
        this.text = null;
        super.tearDown();
    }

    public void testScenario01() {
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"name"));
        TextControlScenario.assertEquals((String)this.adventure.getName(), (String)this.text.getText());
        this.text.setText("England");
        this.text.notifyListeners(16, null);
        TextControlScenario.assertEquals((String)"England", (String)this.adventure.getName());
        this.adventure.setName("France");
        TextControlScenario.assertEquals((String)"France", (String)this.text.getText());
        this.adventure.setName("Germany");
        this.spinEventLoop(0);
        TextControlScenario.assertEquals((String)"Germany", (String)this.text.getText());
    }

    public void testScenario02() {
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), BeansObservables.observeValue((Object)this.transportation, (String)"price"));
        NumberFormat numberFormat = NumberFormat.getInstance();
        TextControlScenario.assertEquals((String)numberFormat.format(this.transportation.getPrice()), (String)this.text.getText());
        this.text.setText("9876.54");
        this.text.notifyListeners(16, null);
        TextControlScenario.assertEquals((double)9876.54, (double)this.transportation.getPrice(), (double)0.0);
        this.transportation.setPrice(1234.56);
        TextControlScenario.assertEquals((String)numberFormat.format(this.transportation.getPrice()), (String)this.text.getText());
    }

    public void testScenario06() {
    }

    public void testScenario07() {
    }

    public void testScenario08() {
        if (BindingTestSuite.failingTestsDisabled(this)) {
            return;
        }
        DataBindingContext dbc = this.getDbc();
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), BeansObservables.observeValue((Object)this.adventure, (String)"maxNumberOfPeople"), (UpdateValueStrategy)new CustomBeanUpdateValueStrategy(), null);
        this.text.setText("4");
        TextControlScenario.assertEquals((int)4, (int)this.adventure.getMaxNumberOfPeople());
        this.text.setText("999");
        TextControlScenario.assertEquals((int)4, (int)this.adventure.getMaxNumberOfPeople());
        dbc.dispose();
    }

    public void testScenario09() {
        Label label = new Label(this.getComposite(), 0);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)16), (IObservableValue)SWTObservables.observeText((Control)label));
        this.text.setText("Frog");
        TextControlScenario.assertTrue((label.getText().length() == 0 ? 1 : 0) != 0);
        this.text.notifyListeners(16, null);
        TextControlScenario.assertEquals((String)label.getText(), (String)"Frog");
    }

    public void testScenario10() {
        Label label = new Label(this.getComposite(), 0);
        this.getDbc().bindValue((IObservableValue)SWTObservables.observeText((Control)this.text, (int)24), (IObservableValue)SWTObservables.observeText((Control)label));
        String newTextValue = "Frog";
        int i = 0;
        while (i < newTextValue.length()) {
            this.text.setText(newTextValue.substring(0, i + 1));
            TextControlScenario.assertEquals((String)this.text.getText(), (String)label.getText());
            ++i;
        }
        this.text.notifyListeners(16, null);
        TextControlScenario.assertEquals((String)this.text.getText(), (String)label.getText());
    }
}

