/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.swt;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.tests.databinding.observable.ThreadRealm;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.conformance.util.RealmTester;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WidgetObservableThreadTest
extends AbstractSWTTestCase {
    protected ThreadRealm threadRealm;
    private DataBindingContext ctx;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.threadRealm = new ThreadRealm();
        new Thread(){

            @Override
            public void run() {
                RealmTester.setDefault((Realm)WidgetObservableThreadTest.this.threadRealm);
                WidgetObservableThreadTest.this.threadRealm.init(Thread.currentThread());
                WidgetObservableThreadTest.this.threadRealm.block();
            }
        }.start();
        this.threadRealm.waitUntilBlocking();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.ctx != null) {
            this.threadRealm.exec(new Runnable(){

                @Override
                public void run() {
                    WidgetObservableThreadTest.this.ctx.dispose();
                    WidgetObservableThreadTest.this.ctx = null;
                }
            });
            this.threadRealm.processQueue();
        }
        this.threadRealm.unblock();
        this.threadRealm = null;
        super.tearDown();
    }

    public void testBindWidgetObservableFromNonDisplayThread() {
        final Text text = new Text((Composite)this.getShell(), 2048);
        final Bean bean = new Bean("oldValue");
        WidgetObservableThreadTest.assertEquals((String)"oldValue", (String)bean.getValue());
        WidgetObservableThreadTest.assertEquals((String)"", (String)text.getText());
        this.threadRealm.exec(new Runnable(){

            @Override
            public void run() {
                WidgetObservableThreadTest.this.ctx = new DataBindingContext();
                WidgetObservableThreadTest.this.ctx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), BeanProperties.value((String)"value").observe((Realm)WidgetObservableThreadTest.this.threadRealm, (Object)bean));
            }
        });
        this.threadRealm.processQueue();
        WidgetObservableThreadTest.assertEquals((String)"oldValue", (String)bean.getValue());
        WidgetObservableThreadTest.assertEquals((String)"", (String)text.getText());
        this.processDisplayQueue();
        this.threadRealm.processQueue();
        WidgetObservableThreadTest.assertEquals((String)"oldValue", (String)bean.getValue());
        WidgetObservableThreadTest.assertEquals((String)"oldValue", (String)text.getText());
        text.setText("newValue");
        this.threadRealm.processQueue();
        WidgetObservableThreadTest.assertEquals((String)"newValue", (String)bean.getValue());
        WidgetObservableThreadTest.assertEquals((String)"newValue", (String)text.getText());
        this.threadRealm.exec(new Runnable(){

            @Override
            public void run() {
                bean.setValue("newerValue");
            }
        });
        this.threadRealm.processQueue();
        WidgetObservableThreadTest.assertEquals((String)"newerValue", (String)bean.getValue());
        WidgetObservableThreadTest.assertEquals((String)"newValue", (String)text.getText());
        this.processDisplayQueue();
        WidgetObservableThreadTest.assertEquals((String)"newerValue", (String)bean.getValue());
        WidgetObservableThreadTest.assertEquals((String)"newerValue", (String)text.getText());
    }

    private void processDisplayQueue() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

