/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ObservableListTreeContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TreeViewer viewer;
    private Tree tree;
    private ObservableListTreeContentProvider contentProvider;
    private Object input;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.tree = new Tree((Composite)this.shell, 0);
        this.viewer = new TreeViewer(this.tree);
        this.input = new Object();
    }

    @Override
    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.tree = null;
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    private void initContentProvider(IObservableFactory listFactory) {
        this.contentProvider = new ObservableListTreeContentProvider(listFactory, null);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(this.input);
    }

    public void testConstructor_NullArgumentThrowsException() {
        try {
            this.initContentProvider(null);
            ObservableListTreeContentProviderTest.fail((String)"Constructor should have thrown AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testGetElements_ChangesFollowObservedList() {
        WritableList elements = new WritableList();
        final Object input = new Object();
        this.initContentProvider(new IObservableFactory((IObservableList)elements){
            private final /* synthetic */ IObservableList val$elements;
            {
                this.val$elements = iObservableList;
            }

            public IObservable createObservable(Object target) {
                return target == input ? this.val$elements : null;
            }
        });
        ObservableListTreeContentProviderTest.assertTrue((boolean)Arrays.equals(new Object[0], this.contentProvider.getElements((Object)"unknown input")));
        Object element0 = new Object();
        elements.add(element0);
        ObservableListTreeContentProviderTest.assertTrue((boolean)Arrays.equals(new Object[]{element0}, this.contentProvider.getElements(input)));
        Object element1 = new Object();
        elements.add(element1);
        ObservableListTreeContentProviderTest.assertTrue((boolean)Arrays.equals(new Object[]{element0, element1}, this.contentProvider.getElements(input)));
    }

    public void testViewerUpdate_RemoveElementAfterMutation() {
        WritableList children = new WritableList();
        this.initContentProvider(new IObservableFactory((IObservableList)children){
            private final /* synthetic */ IObservableList val$children;
            {
                this.val$children = iObservableList;
            }

            public IObservable createObservable(Object target) {
                return target == ObservableListTreeContentProviderTest.this.input ? this.val$children : null;
            }
        });
        Mutable element = new Mutable();
        children.add((Object)element);
        ObservableListTreeContentProviderTest.assertEquals((int)1, (int)this.tree.getItemCount());
        element.mutate();
        children.remove((Object)element);
        ObservableListTreeContentProviderTest.assertEquals((int)0, (int)this.tree.getItemCount());
    }

    public void testInputChanged_ClearsKnownElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableList children = new WritableList();
        WritableList children2 = new WritableList();
        this.initContentProvider(new IObservableFactory((IObservableList)children, input2, (IObservableList)children2){
            private final /* synthetic */ IObservableList val$children;
            private final /* synthetic */ Object val$input2;
            private final /* synthetic */ IObservableList val$children2;
            {
                this.val$children = iObservableList;
                this.val$input2 = object;
                this.val$children2 = iObservableList2;
            }

            public IObservable createObservable(Object target) {
                if (target == ObservableListTreeContentProviderTest.this.input) {
                    return this.val$children;
                }
                if (target == this.val$input2) {
                    return this.val$children2;
                }
                return null;
            }
        });
        Object element = new Object();
        children.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        ObservableListTreeContentProviderTest.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput(input2);
        ObservableListTreeContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)knownElements);
    }

    public void testInputChanged_ClearsRealizedElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableList children = new WritableList();
        WritableList children2 = new WritableList();
        this.initContentProvider(new IObservableFactory((IObservableList)children, input2, (IObservableList)children2){
            private final /* synthetic */ IObservableList val$children;
            private final /* synthetic */ Object val$input2;
            private final /* synthetic */ IObservableList val$children2;
            {
                this.val$children = iObservableList;
                this.val$input2 = object;
                this.val$children2 = iObservableList2;
            }

            public IObservable createObservable(Object target) {
                if (target == ObservableListTreeContentProviderTest.this.input) {
                    return this.val$children;
                }
                if (target == this.val$input2) {
                    return this.val$children2;
                }
                return null;
            }
        });
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        children.add(element);
        ObservableListTreeContentProviderTest.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput(input2);
        ObservableListTreeContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)realizedElements);
    }

    static class Mutable {
        private int id;

        public Mutable() {
            this(0);
        }

        public Mutable(int id) {
            this.id = id;
        }

        public void mutate() {
            ++this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

