/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.HashSet;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.examples.databinding.ModelObject;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;

public class ObservableMapLabelProviderTest
extends AbstractDefaultRealmTestCase {
    public void testGetColumnText() throws Exception {
        WritableSet set = new WritableSet(new HashSet(), Item.class);
        Item item = new Item();
        String value = "value";
        item.setValue(value);
        set.add((Object)item);
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(BeansObservables.observeMap((IObservableSet)set, Item.class, (String)"value"));
        ObservableMapLabelProviderTest.assertEquals((String)item.getValue(), (String)labelProvider.getColumnText((Object)item, 0));
    }

    public void testGetColumnTextNullValue() throws Exception {
        WritableSet set = new WritableSet(new HashSet(), Item.class);
        Item item = new Item();
        set.add((Object)item);
        ObservableMapLabelProvider labelProvider = new ObservableMapLabelProvider(BeansObservables.observeMap((IObservableSet)set, Item.class, (String)"value"));
        ObservableMapLabelProviderTest.assertNull((Object)item.getValue());
        ObservableMapLabelProviderTest.assertEquals((String)"", (String)labelProvider.getColumnText((Object)item, 0));
    }

    private static class Item
    extends ModelObject {
        private String value;

        private Item() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            String old = this.value;
            this.value = value;
            this.firePropertyChange("value", old, this.value);
        }
    }
}

