/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.internal.databinding.viewers.ObservableViewerElementSet;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class ObservableSetTreeContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TreeViewer viewer;
    private Tree tree;
    private ObservableSetTreeContentProvider contentProvider;
    private Object input;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.tree = new Tree((Composite)this.shell, 0);
        this.viewer = new TreeViewer(this.tree);
        this.input = new Object();
    }

    @Override
    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.tree = null;
        this.viewer = null;
        this.input = null;
        super.tearDown();
    }

    private void initContentProvider(IObservableFactory listFactory) {
        this.contentProvider = new ObservableSetTreeContentProvider(listFactory, null);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(this.input);
    }

    public void testConstructor_NullArgumentThrowsException() {
        try {
            this.initContentProvider(null);
            ObservableSetTreeContentProviderTest.fail((String)"Constructor should have thrown AssertionFailedException");
        }
        catch (AssertionFailedException assertionFailedException) {}
    }

    public void testGetElements_ChangesFollowObservedList() {
        WritableSet elements = new WritableSet();
        final Object input = new Object();
        this.initContentProvider(new IObservableFactory((IObservableSet)elements){
            private final /* synthetic */ IObservableSet val$elements;
            {
                this.val$elements = iObservableSet;
            }

            public IObservable createObservable(Object target) {
                return target == input ? this.val$elements : null;
            }
        });
        ObservableSetTreeContentProviderTest.assertTrue((boolean)Arrays.equals(new Object[0], this.contentProvider.getElements((Object)"unknown input")));
        Object element0 = new Object();
        elements.add(element0);
        ObservableSetTreeContentProviderTest.assertTrue((boolean)Arrays.equals(new Object[]{element0}, this.contentProvider.getElements(input)));
        Object element1 = new Object();
        elements.add(element1);
        List<Object> elementList = Arrays.asList(this.contentProvider.getElements(input));
        ObservableSetTreeContentProviderTest.assertEquals((int)2, (int)elementList.size());
        ObservableSetTreeContentProviderTest.assertTrue((boolean)elementList.containsAll(Arrays.asList(element0, element1)));
    }

    public void testViewerUpdate_RemoveElementAfterMutation() {
        IElementComparer comparer = new IElementComparer(){

            public boolean equals(Object a, Object b) {
                return a == b;
            }

            public int hashCode(Object element) {
                return System.identityHashCode(element);
            }
        };
        this.viewer.setComparer(comparer);
        final IObservableSet children = ObservableViewerElementSet.withComparer((Realm)Realm.getDefault(), null, (IElementComparer)comparer);
        this.initContentProvider(new IObservableFactory(){

            public IObservable createObservable(Object target) {
                return target == ObservableSetTreeContentProviderTest.this.input ? children : null;
            }
        });
        Mutable element = new Mutable();
        children.add((Object)element);
        ObservableSetTreeContentProviderTest.assertEquals((int)1, (int)this.tree.getItemCount());
        element.mutate();
        ObservableSetTreeContentProviderTest.assertTrue((boolean)children.remove((Object)element));
        ObservableSetTreeContentProviderTest.assertEquals((int)0, (int)this.tree.getItemCount());
    }

    public void testInputChanged_ClearsKnownElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableSet children = new WritableSet();
        WritableSet children2 = new WritableSet();
        this.initContentProvider(new IObservableFactory((IObservableSet)children, input2, (IObservableSet)children2){
            private final /* synthetic */ IObservableSet val$children;
            private final /* synthetic */ Object val$input2;
            private final /* synthetic */ IObservableSet val$children2;
            {
                this.val$children = iObservableSet;
                this.val$input2 = object;
                this.val$children2 = iObservableSet2;
            }

            public IObservable createObservable(Object target) {
                if (target == ObservableSetTreeContentProviderTest.this.input) {
                    return this.val$children;
                }
                if (target == this.val$input2) {
                    return this.val$children2;
                }
                return null;
            }
        });
        Object element = new Object();
        children.add(element);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        ObservableSetTreeContentProviderTest.assertEquals(Collections.singleton(element), (Object)knownElements);
        this.viewer.setInput(input2);
        ObservableSetTreeContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)knownElements);
    }

    public void testInputChanged_ClearsRealizedElements() {
        this.input = new Object();
        Object input2 = new Object();
        WritableSet children = new WritableSet();
        WritableSet children2 = new WritableSet();
        this.initContentProvider(new IObservableFactory((IObservableSet)children, input2, (IObservableSet)children2){
            private final /* synthetic */ IObservableSet val$children;
            private final /* synthetic */ Object val$input2;
            private final /* synthetic */ IObservableSet val$children2;
            {
                this.val$children = iObservableSet;
                this.val$input2 = object;
                this.val$children2 = iObservableSet2;
            }

            public IObservable createObservable(Object target) {
                if (target == ObservableSetTreeContentProviderTest.this.input) {
                    return this.val$children;
                }
                if (target == this.val$input2) {
                    return this.val$children2;
                }
                return null;
            }
        });
        IObservableSet realizedElements = this.contentProvider.getRealizedElements();
        Object element = new Object();
        children.add(element);
        ObservableSetTreeContentProviderTest.assertEquals(Collections.singleton(element), (Object)realizedElements);
        this.viewer.setInput(input2);
        ObservableSetTreeContentProviderTest.assertEquals((Object)Collections.EMPTY_SET, (Object)realizedElements);
    }

    static class Mutable {
        private int id;

        public Mutable() {
            this(0);
        }

        public Mutable(int id) {
            this.id = id;
        }

        public void mutate() {
            ++this.id;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Mutable that = (Mutable)obj;
            return this.id == that.id;
        }

        public int hashCode() {
            return this.id;
        }
    }
}

