/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ObservableValueEditingSupportTest
extends AbstractSWTTestCase {
    private Shell shell;
    private ObservableValueEditingSupportStub editingSupport;
    private DataBindingContext dbc;
    private TableViewer viewer;
    private Bean bean;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.shell = this.getShell();
        this.dbc = new DataBindingContext();
        this.viewer = new TableViewer((Composite)this.shell);
        TableViewerColumn column = new TableViewerColumn(this.viewer, 0);
        this.editingSupport = new ObservableValueEditingSupportStub((ColumnViewer)this.viewer, this.dbc);
        column.setEditingSupport((EditingSupport)this.editingSupport);
        WritableList input = WritableList.withElementType(String.class);
        this.bean = new Bean();
        this.bean.setValue("value");
        input.add((Object)this.bean);
        ViewerSupport.bind((StructuredViewer)this.viewer, (IObservableList)input, (IValueProperty)BeanProperties.value(Bean.class, (String)"value"));
    }

    public void testInitializeCellEditorValue_OrderOfOperations() throws Exception {
        ObservableValueEditingSupportTest.assertEquals((String)"precondition", (int)0, (int)this.editingSupport.events.length());
        this.viewer.editElement((Object)this.bean, 0);
        ObservableValueEditingSupportTest.assertEquals((String)"createCellEditorObservable createElementObservable createBinding", (String)this.editingSupport.events.toString());
    }

    public void testSaveCellEditorValue_UpdatesModel() throws Exception {
        this.shell.open();
        String newValue = String.valueOf(this.bean.getValue()) + "a";
        this.viewer.editElement((Object)this.bean, 0);
        this.editingSupport.target.setValue((Object)newValue);
        this.closeCellEditor();
        ObservableValueEditingSupportTest.assertTrue((boolean)this.editingSupport.binding.isDisposed());
        ObservableValueEditingSupportTest.assertEquals((String)newValue, (String)this.bean.getValue());
    }

    protected void closeCellEditor() {
        this.editingSupport.text.notifyListeners(14, new Event());
    }

    public void testSaveCellEditorValue_IgnoreIfNotDirty() throws Exception {
        String initialValue = this.bean.getValue();
        this.shell.open();
        this.viewer.editElement((Object)this.bean, 0);
        this.closeCellEditor();
        ObservableValueEditingSupportTest.assertTrue((boolean)this.editingSupport.binding.isDisposed());
        ObservableValueEditingSupportTest.assertEquals((String)initialValue, (String)this.bean.getValue());
    }

    public void testDisposesBinding() throws Exception {
        this.shell.open();
        this.viewer.editElement((Object)this.bean, 0);
        ObservableValueEditingSupportTest.assertFalse((String)"precondition", (boolean)this.editingSupport.binding.isDisposed());
        this.closeCellEditor();
        ObservableValueEditingSupportTest.assertTrue((boolean)this.editingSupport.binding.isDisposed());
    }

    public void testDisposesTargetObservable() throws Exception {
        this.shell.open();
        this.viewer.editElement((Object)this.bean, 0);
        ObservableValueEditingSupportTest.assertFalse((String)"precondition", (boolean)this.editingSupport.target.isDisposed());
        this.closeCellEditor();
        ObservableValueEditingSupportTest.assertTrue((boolean)this.editingSupport.target.isDisposed());
    }

    public void testDisposesModelObservable() throws Exception {
        this.shell.open();
        this.viewer.editElement((Object)this.bean, 0);
        ObservableValueEditingSupportTest.assertFalse((String)"precondition", (boolean)this.editingSupport.model.isDisposed());
        this.closeCellEditor();
        ObservableValueEditingSupportTest.assertTrue((boolean)this.editingSupport.model.isDisposed());
    }

    public void testCanEdit_DefaultIsTrue() throws Exception {
        ObservableValueEditingSupportTest.assertTrue((boolean)this.editingSupport.canEdit(this.bean));
    }

    private static class ObservableValueEditingSupportStub
    extends ObservableValueEditingSupport {
        StringBuffer events = new StringBuffer();
        Text text;
        TextCellEditor editor;
        Binding binding;
        IObservableValue target;
        IObservableValue model;

        public ObservableValueEditingSupportStub(ColumnViewer viewer, DataBindingContext dbc) {
            super(viewer, dbc);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return super.canEdit(element);
        }

        private void event(String event) {
            if (this.events.length() > 0) {
                this.events.append(" ");
            }
            this.events.append(event);
        }

        protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor) {
            this.event("createCellEditorObservable");
            this.text = (Text)cellEditor.getControl();
            this.target = SWTObservables.observeText((Control)cellEditor.getControl(), (int)0);
            return this.target;
        }

        protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
            this.event("createElementObservable");
            this.model = BeansObservables.observeValue((Object)element, (String)"value");
            return this.model;
        }

        protected Binding createBinding(IObservableValue target, IObservableValue model) {
            this.event("createBinding");
            this.binding = super.createBinding(target, model);
            return this.binding;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }
    }
}

