/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.viewers;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.databinding.util.ILogger;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.internal.databinding.beans.Bean;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.jface.util.ISafeRunnableRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class ViewerSupportTest
extends AbstractSWTTestCase {
    private ILogger oldLog;
    private ISafeRunnableRunner oldRunner;
    private AbstractTableViewer structuredViewer;
    private AbstractTreeViewer treeViewer;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.oldLog = Policy.getLog();
        Policy.setLog((ILogger)new ILogger(){

            public void log(IStatus status) {
                if (status.getException() != null) {
                    throw new RuntimeException(status.getException());
                }
                ViewerSupportTest.fail((String)("Unexpected status: " + status));
            }
        });
        this.oldRunner = SafeRunnable.getRunner();
        SafeRunnable.setRunner((ISafeRunnableRunner)new ISafeRunnableRunner(){

            public void run(ISafeRunnable code) {
                try {
                    code.run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.structuredViewer != null) {
            this.structuredViewer.getControl().dispose();
        }
        if (this.treeViewer != null) {
            this.treeViewer.getControl().dispose();
        }
        Policy.setLog((ILogger)this.oldLog);
        SafeRunnable.setRunner((ISafeRunnableRunner)this.oldRunner);
        super.tearDown();
    }

    private StructuredViewer getStructuredViewer() {
        if (this.structuredViewer == null) {
            this.structuredViewer = new TableViewer((Composite)this.getShell());
        }
        return this.structuredViewer;
    }

    private AbstractTreeViewer getTreeViewer() {
        if (this.treeViewer == null) {
            this.treeViewer = new TreeViewer((Composite)this.getShell());
        }
        return this.treeViewer;
    }

    public void testBindList_Twice() {
        StructuredViewer viewer = this.getStructuredViewer();
        WritableList input0 = WritableList.withElementType(Bean.class);
        WritableList input1 = WritableList.withElementType(Bean.class);
        input0.add((Object)new Bean("element0"));
        input1.add((Object)new Bean("element1"));
        IBeanValueProperty labelProp = BeanProperties.value(Bean.class, (String)"value");
        ViewerSupport.bind((StructuredViewer)viewer, (IObservableList)input0, (IValueProperty)labelProp);
        ViewerSupport.bind((StructuredViewer)viewer, (IObservableList)input1, (IValueProperty)labelProp);
    }

    public void testBindSet_Twice() {
        StructuredViewer viewer = this.getStructuredViewer();
        WritableSet input0 = WritableSet.withElementType(Bean.class);
        WritableSet input1 = WritableSet.withElementType(Bean.class);
        input0.add((Object)new Bean("element0"));
        input1.add((Object)new Bean("element1"));
        IBeanValueProperty labelProp = BeanProperties.value(Bean.class, (String)"value");
        ViewerSupport.bind((StructuredViewer)viewer, (IObservableSet)input0, (IValueProperty)labelProp);
        ViewerSupport.bind((StructuredViewer)viewer, (IObservableSet)input1, (IValueProperty)labelProp);
    }

    public void testBindListTree_Twice() {
        AbstractTreeViewer viewer = this.getTreeViewer();
        Bean input0 = new Bean(Arrays.asList(new Bean("elem0"), new Bean("elem1"), new Bean("elem2")));
        Bean input1 = new Bean(Arrays.asList(new Bean("elem3"), new Bean("elem4"), new Bean("elem5")));
        IBeanValueProperty labelProp = BeanProperties.value(Bean.class, (String)"value");
        IBeanListProperty childrenProp = BeanProperties.list(Bean.class, (String)"list");
        ViewerSupport.bind((AbstractTreeViewer)viewer, (Object)input0, (IListProperty)childrenProp, (IValueProperty)labelProp);
        ViewerSupport.bind((AbstractTreeViewer)viewer, (Object)input1, (IListProperty)childrenProp, (IValueProperty)labelProp);
    }

    public void testBindSetTree_Twice() {
        AbstractTreeViewer viewer = this.getTreeViewer();
        Bean input0 = new Bean(new HashSet<Bean>(Arrays.asList(new Bean("elem0"), new Bean("elem1"), new Bean("elem2"))));
        Bean input1 = new Bean(new HashSet<Bean>(Arrays.asList(new Bean("elem3"), new Bean("elem4"), new Bean("elem5"))));
        IBeanValueProperty labelProp = BeanProperties.value(Bean.class, (String)"value");
        IBeanSetProperty childrenProp = BeanProperties.set(Bean.class, (String)"set");
        ViewerSupport.bind((AbstractTreeViewer)viewer, (Object)input0, (ISetProperty)childrenProp, (IValueProperty)labelProp);
        ViewerSupport.bind((AbstractTreeViewer)viewer, (Object)input1, (ISetProperty)childrenProp, (IValueProperty)labelProp);
    }
}

