/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.databinding.wizard;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.commands.util.Util;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.dialog.IValidationMessageProvider;
import org.eclipse.jface.databinding.dialog.ValidationMessageProvider;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WizardPageSupportTest
extends AbstractSWTTestCase {
    public void testPageComplete() {
        WizardPage page = new WizardPage("Page"){

            public void createControl(Composite parent) {
                this.setControl((Control)parent);
                WritableValue validation = new WritableValue((Object)ValidationStatus.ok(), IStatus.class);
                DataBindingContext dbc = new DataBindingContext();
                ValidationProvider validationProvider = new ValidationProvider((IObservableValue)validation);
                dbc.addValidationStatusProvider((ValidationStatusProvider)validationProvider);
                WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
                validation.setValue((Object)ValidationStatus.info((String)"INFO"));
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
                validation.setValue((Object)ValidationStatus.warning((String)"WARNING"));
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
                validation.setValue((Object)ValidationStatus.error((String)"ERROR"));
                WizardPageSupportTest.assertFalse((boolean)this.isPageComplete());
                validation.setValue((Object)ValidationStatus.cancel((String)"CANCEL"));
                WizardPageSupportTest.assertFalse((boolean)this.isPageComplete());
            }
        };
        this.loadWizardPage((IWizardPage)page);
    }

    public void testPageCompleteOnValidationStaleness() {
        WizardPage page = new WizardPage("Page"){

            public void createControl(Composite parent) {
                this.setControl((Control)parent);
                ValidationObservable validation = new ValidationObservable();
                DataBindingContext dbc = new DataBindingContext();
                dbc.addValidationStatusProvider((ValidationStatusProvider)new ValidationProvider((IObservableValue)validation));
                WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
                validation.setStale(true);
                WizardPageSupportTest.assertFalse((boolean)this.isPageComplete());
                validation.setStale(false);
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
            }
        };
        this.loadWizardPage((IWizardPage)page);
    }

    public void testValidationMessageProvider() {
        WizardPage page = new WizardPage("Page"){

            public void createControl(Composite parent) {
                this.setControl((Control)parent);
                ValidationObservable validation = new ValidationObservable();
                DataBindingContext dbc = new DataBindingContext();
                dbc.addValidationStatusProvider((ValidationStatusProvider)new ValidationProvider((IObservableValue)validation));
                WizardPageSupport wizardPageSupport = WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
                TestValidationMessageProvider messageProvider = new TestValidationMessageProvider();
                wizardPageSupport.setValidationMessageProvider((IValidationMessageProvider)messageProvider);
                messageProvider.message = "message1";
                messageProvider.messageType = 2;
                validation.setValue(ValidationStatus.info((String)"INFO"));
                WizardPageSupportTest.assertEquals((String)messageProvider.message, (String)this.getMessage());
                WizardPageSupportTest.assertEquals((int)messageProvider.messageType, (int)this.getMessageType());
                WizardPageSupportTest.assertNull((Object)this.getErrorMessage());
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
                messageProvider.message = "message2";
                messageProvider.messageType = 0;
                validation.setValue(ValidationStatus.error((String)"ERROR"));
                WizardPageSupportTest.assertEquals((String)messageProvider.message, (String)this.getMessage());
                WizardPageSupportTest.assertEquals((int)messageProvider.messageType, (int)this.getMessageType());
                WizardPageSupportTest.assertNull((Object)this.getErrorMessage());
                WizardPageSupportTest.assertFalse((boolean)this.isPageComplete());
                messageProvider.message = null;
                validation.setValue(ValidationStatus.ok());
                WizardPageSupportTest.assertEquals((String)messageProvider.message, (String)this.getMessage());
                WizardPageSupportTest.assertEquals((int)messageProvider.messageType, (int)this.getMessageType());
                WizardPageSupportTest.assertNull((Object)this.getErrorMessage());
                WizardPageSupportTest.assertTrue((boolean)this.isPageComplete());
                messageProvider.message = "message3";
                messageProvider.messageType = 3;
                validation.setValue(ValidationStatus.error((String)"ERROR"));
                WizardPageSupportTest.assertNull((Object)this.getMessage());
                WizardPageSupportTest.assertEquals((int)0, (int)this.getMessageType());
                WizardPageSupportTest.assertEquals((String)messageProvider.message, (String)this.getErrorMessage());
                WizardPageSupportTest.assertFalse((boolean)this.isPageComplete());
            }
        };
        this.loadWizardPage((IWizardPage)page);
    }

    private void loadWizardPage(IWizardPage page) {
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                return true;
            }
        };
        wizard.addPage(page);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        dialog.create();
    }

    private static class TestValidationMessageProvider
    extends ValidationMessageProvider {
        public String message;
        public int messageType;

        private TestValidationMessageProvider() {
        }

        public String getMessage(ValidationStatusProvider statusProvider) {
            return this.message;
        }

        public int getMessageType(ValidationStatusProvider statusProvider) {
            return this.messageType;
        }
    }

    private static class ValidationObservable
    extends AbstractObservableValue {
        private Object value = ValidationStatus.ok();
        private boolean stale = false;

        public ValidationObservable() {
            super(Realm.getDefault());
        }

        protected Object doGetValue() {
            return this.value;
        }

        protected void doSetValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            if (!Util.equals((Object)oldValue, (Object)value)) {
                this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
            }
        }

        public boolean isStale() {
            ObservableTracker.getterCalled((IObservable)this);
            return this.stale;
        }

        public void setStale(boolean stale) {
            if (this.stale != stale) {
                this.stale = stale;
                if (stale) {
                    this.fireStale();
                } else {
                    this.fireValueChange(Diffs.createValueDiff((Object)this.value, (Object)this.value));
                }
            }
        }

        public Object getValueType() {
            return IStatus.class;
        }
    }

    private static class ValidationProvider
    extends ValidationStatusProvider {
        private final IObservableValue validation;

        public ValidationProvider(IObservableValue validation) {
            this.validation = validation;
        }

        public IObservableValue getValidationStatus() {
            return this.validation;
        }

        public IObservableList getTargets() {
            WritableList targets = new WritableList();
            targets.add((Object)this.validation);
            return targets;
        }

        public IObservableList getModels() {
            return Observables.emptyObservableList();
        }
    }
}

