/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.examples.databinding.mask.internal;

import junit.framework.TestCase;
import org.eclipse.jface.examples.databinding.mask.internal.EditMaskLexerAndToken;

public class EditMaskLexerAndTokenTest
extends TestCase {
    private EditMaskLexerAndToken token;

    protected void setUp() throws Exception {
        this.token = new EditMaskLexerAndToken();
    }

    public void testInitWithNumeric() throws Exception {
        this.token.initializeEditMask("#", 0);
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("0"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("1"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("2"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("3"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("4"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("5"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("6"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("7"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("8"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a digit", (boolean)this.token.accept("9"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertFalse((String)"Should not accept an alpha", (boolean)this.token.accept("A"));
        this.token.clear();
        EditMaskLexerAndTokenTest.assertFalse((String)"Should not accept an alpha", (boolean)this.token.accept("z"));
        EditMaskLexerAndTokenTest.assertFalse((String)"Placeholders are not read-only", (boolean)this.token.isReadOnly());
    }

    public void testInitWithLiteral() throws Exception {
        this.token.initializeEditMask("(", 0);
        EditMaskLexerAndTokenTest.assertEquals((String)"Literals automatically set their input", (String)"(", (String)this.token.getInput());
        EditMaskLexerAndTokenTest.assertFalse((String)"Literals don't accept anything", (boolean)this.token.accept("("));
        EditMaskLexerAndTokenTest.assertTrue((String)"literals are read-only", (boolean)this.token.isReadOnly());
        EditMaskLexerAndTokenTest.assertTrue((String)"Literals are complete", (boolean)this.token.isComplete());
        EditMaskLexerAndTokenTest.assertFalse((String)"Literals cannot accept characters", (boolean)this.token.canAcceptMoreCharacters());
    }

    public void testInitWithBackslashLiteral() throws Exception {
        this.token.initializeEditMask("\\#", 0);
        EditMaskLexerAndTokenTest.assertEquals((String)"Should get backslash literal", (String)"#", (String)this.token.getInput());
    }

    public void testAcceptWithValidInputAndEmpty() throws Exception {
        this.token.initializeEditMask("#", 0);
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a 0", (boolean)this.token.accept("0"));
    }

    public void testAcceptWhenParserCannotAcceptMoreCharacters() throws Exception {
        this.token.initializeEditMask("#", 0);
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a 0", (boolean)this.token.accept("0"));
        EditMaskLexerAndTokenTest.assertFalse((String)"Should not accept a 0 -- input full", (boolean)this.token.accept("0"));
    }

    public void testGetInput() throws Exception {
        this.token.initializeEditMask("#", 0);
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a #", (boolean)this.token.accept("0"));
        EditMaskLexerAndTokenTest.assertEquals((String)this.token.getInput(), (String)"0");
    }

    public void testClear_withNonLiteral() throws Exception {
        this.token.initializeEditMask("#", 0);
        EditMaskLexerAndTokenTest.assertTrue((String)"Should accept a 0", (boolean)this.token.accept("0"));
        EditMaskLexerAndTokenTest.assertNotNull((String)"Input should not be null", (Object)this.token.getInput());
        this.token.clear();
        EditMaskLexerAndTokenTest.assertNull((String)"Input should be null after clear", (Object)this.token.getInput());
    }

    public void testClear_withLiteral() throws Exception {
        this.token.initializeEditMask("(", 0);
        EditMaskLexerAndTokenTest.assertNotNull((String)"Input should not be null", (Object)this.token.getInput());
        this.token.clear();
        EditMaskLexerAndTokenTest.assertNotNull((String)"Input should still not be null after clear of read-only literal", (Object)this.token.getInput());
    }

    public void testIsComplete_withNonLiteral() throws Exception {
        this.token.initializeEditMask("#", 0);
        EditMaskLexerAndTokenTest.assertFalse((String)"should not be complete", (boolean)this.token.isComplete());
        this.token.accept("1");
        EditMaskLexerAndTokenTest.assertTrue((String)"should be complete", (boolean)this.token.isComplete());
        this.token.clear();
        EditMaskLexerAndTokenTest.assertFalse((String)"should not be complete", (boolean)this.token.isComplete());
    }
}

