/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.examples.databinding.mask.internal;

import junit.framework.TestCase;
import org.eclipse.jface.examples.databinding.mask.EditMaskParseException;
import org.eclipse.jface.examples.databinding.mask.internal.EditMaskParser;

public class EditMaskParserTest
extends TestCase {
    private EditMaskParser parser;

    protected void setUp() throws Exception {
        this.parser = new EditMaskParser("(###) ###-####");
    }

    public void testEditMaskParser_validMask() {
        new EditMaskParser("(###) ###-####");
    }

    public void testEditMaskParser_invalidMask() {
        try {
            new EditMaskParser("(###) ###-####\\");
            EditMaskParserTest.fail((String)"Should have thrown exception");
        }
        catch (EditMaskParseException editMaskParseException) {}
    }

    public void testSetInput() {
        this.parser.setInput("63a0) 5*55-1\\212abc9");
        EditMaskParserTest.assertEquals((String)"Unformatted input", (String)"6305551212", (String)this.parser.getRawResult());
        EditMaskParserTest.assertEquals((String)"Formatted input", (String)"(630) 555-1212", (String)this.parser.getFormattedResult());
    }

    public void testSetInput_incomplete() {
        this.parser.setInput("6a0) 5*5-1\\12");
        EditMaskParserTest.assertEquals((String)"Unformatted input", (String)"6055112", (String)this.parser.getRawResult());
        EditMaskParserTest.assertEquals((String)"Formatted input", (String)"(605) 511-2   ", (String)this.parser.getFormattedResult());
    }

    public void testIsComplete() {
        this.parser.setInput("63a0) 5*55-1\\212");
        EditMaskParserTest.assertTrue((String)"complete", (boolean)this.parser.isComplete());
        this.parser.setInput("6a0) 5*5-1\\12");
        EditMaskParserTest.assertFalse((String)"incomplete", (boolean)this.parser.isComplete());
    }

    public void testSetPlaceholder() throws Exception {
        this.parser.setInput("6a0) 5*5-1\\12");
        EditMaskParserTest.assertEquals((String)"Formatted input", (String)"(605) 511-2   ", (String)this.parser.getFormattedResult());
        this.parser.setPlaceholder('_');
        EditMaskParserTest.assertEquals((String)"Formatted input", (String)"(605) 511-2___", (String)this.parser.getFormattedResult());
    }

    public void testGetNextInputPosition() {
        EditMaskParserTest.assertEquals((String)"Skip leading (", (int)1, (int)this.parser.getNextInputPosition(0));
        EditMaskParserTest.assertEquals((String)"Position 1 is good", (int)1, (int)this.parser.getNextInputPosition(1));
        EditMaskParserTest.assertEquals((String)"Skip )<space>", (int)6, (int)this.parser.getNextInputPosition(4));
    }

    public void testGetFirstIncompleteInputPosition() throws Exception {
        EditMaskParserTest.assertEquals((String)"1st position incomplete", (int)1, (int)this.parser.getFirstIncompleteInputPosition());
        this.parser.setInput("6a0) 5*5-1\\12");
        EditMaskParserTest.assertEquals((String)"11th position incomplete", (int)11, (int)this.parser.getFirstIncompleteInputPosition());
        this.parser.setInput("63a0) 5*55-1\\212");
        EditMaskParserTest.assertEquals((String)"all complete", (int)-1, (int)this.parser.getFirstIncompleteInputPosition());
    }
}

