/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ButtonObservableValueTest
extends AbstractSWTTestCase {
    private Button button;
    private ISWTObservableValue observableValue;
    private ValueChangeEventTracker listener;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Shell shell = this.getShell();
        this.button = new Button((Composite)shell, 32);
        this.observableValue = SWTObservables.observeSelection((Control)this.button);
        this.listener = new ValueChangeEventTracker();
    }

    public void testSelection_ChangeNotifiesObservable() throws Exception {
        this.observableValue.addValueChangeListener((IValueChangeListener)this.listener);
        this.button.setSelection(true);
        ButtonObservableValueTest.assertEquals((int)0, (int)this.listener.count);
        this.button.notifyListeners(13, null);
        ButtonObservableValueTest.assertEquals((String)"Selection event should notify observable.", (int)1, (int)this.listener.count);
    }

    public void testSelection_NoChange() throws Exception {
        this.button.setSelection(true);
        this.button.notifyListeners(13, null);
        this.observableValue.addValueChangeListener((IValueChangeListener)this.listener);
        ButtonObservableValueTest.assertEquals((int)0, (int)this.listener.count);
        this.button.notifyListeners(13, null);
        ButtonObservableValueTest.assertEquals((String)"Value did not change.  Listeners should not have been notified.", (int)0, (int)this.listener.count);
    }

    public void testSetValue_NullConvertedToFalse() {
        this.button.setSelection(true);
        ButtonObservableValueTest.assertEquals((Object)Boolean.TRUE, (Object)this.observableValue.getValue());
        this.observableValue.setValue(null);
        ButtonObservableValueTest.assertEquals((Object)Boolean.FALSE, (Object)this.observableValue.getValue());
    }

    public void testDispose() throws Exception {
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        this.observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        ButtonObservableValueTest.assertEquals((Object)Boolean.FALSE, (Object)this.observableValue.getValue());
        ButtonObservableValueTest.assertFalse((boolean)this.button.getSelection());
        this.button.setSelection(true);
        this.button.notifyListeners(13, null);
        ButtonObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        ButtonObservableValueTest.assertEquals((Object)Boolean.TRUE, (Object)this.observableValue.getValue());
        ButtonObservableValueTest.assertTrue((boolean)this.button.getSelection());
        this.observableValue.dispose();
        this.button.setSelection(false);
        this.button.notifyListeners(13, null);
        ButtonObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ButtonObservableValueTest.class.getName());
        suite.addTestSuite(ButtonObservableValueTest.class);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        Shell shell;
        Button button;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            this.shell = new Shell();
            this.button = new Button((Composite)this.shell, 32);
        }

        public void tearDown() {
            super.tearDown();
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.selection().observe(realm, (Object)this.button);
        }

        public Object getValueType(IObservableValue observable) {
            return Boolean.TYPE;
        }

        public void change(IObservable observable) {
            ((IObservableValue)observable).setValue((Object)this.changeValue(this.button));
        }

        public Object createValue(IObservableValue observable) {
            return this.changeValue(this.button);
        }

        private boolean changeValue(Button button) {
            return !button.getSelection();
        }
    }
}

