/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CComboObservableValueTest
extends AbstractSWTTestCase {
    public void testDispose() throws Exception {
        CCombo combo = new CCombo((Composite)this.getShell(), 0);
        ISWTObservableValue observableValue = SWTObservables.observeText((Control)combo);
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        CComboObservableValueTest.assertEquals((String)"", (String)combo.getText());
        CComboObservableValueTest.assertEquals((Object)"", (Object)observableValue.getValue());
        String expected1 = "Test123";
        combo.setText(expected1);
        CComboObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        CComboObservableValueTest.assertEquals((String)expected1, (String)combo.getText());
        CComboObservableValueTest.assertEquals((Object)expected1, (Object)observableValue.getValue());
        observableValue.dispose();
        String expected2 = "NewValue123";
        combo.setText(expected2);
        CComboObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        CComboObservableValueTest.assertEquals((String)expected2, (String)combo.getText());
    }

    public void testSetValueWithNull() {
        this.testSetValueWithNull((IValueProperty)WidgetProperties.text());
        this.testSetValueWithNull((IValueProperty)WidgetProperties.selection());
    }

    protected void testSetValueWithNull(IValueProperty property) {
        CCombo combo = new CCombo((Composite)this.getShell(), 0);
        combo.setItems(new String[]{"one", "two", "three"});
        IObservableValue observable = property.observe(Realm.getDefault(), (Object)combo);
        observable.setValue((Object)"two");
        CComboObservableValueTest.assertEquals((String)"two", (String)combo.getText());
        CComboObservableValueTest.assertEquals((int)1, (int)combo.getSelectionIndex());
        observable.setValue(null);
        CComboObservableValueTest.assertEquals((String)"", (String)combo.getText());
        CComboObservableValueTest.assertEquals((int)-1, (int)combo.getSelectionIndex());
    }
}

