/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CComboObservableValueTextTest
extends TestCase {
    private Delegate delegate;
    private CCombo combo;

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = new Delegate();
        this.delegate.setUp();
        this.combo = this.delegate.combo;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delegate.tearDown();
    }

    public void testModify_NotifiesObservable() throws Exception {
        IObservableValue observable = this.delegate.createObservableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        this.combo.setText((String)this.delegate.createValue(observable));
        CComboObservableValueTextTest.assertEquals((String)"Observable was not notified.", (int)1, (int)listener.count);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CComboObservableValueTextTest.class.getName());
        suite.addTestSuite(CComboObservableValueTextTest.class);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        CCombo combo;
        private Shell shell;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.combo = new CCombo((Composite)this.shell, 0);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.combo);
        }

        public void change(IObservable observable) {
            IObservableValue ov = (IObservableValue)observable;
            ov.setValue(this.createValue(ov));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }
}

