/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CLabelObservableValueTest
extends TestCase {
    private Delegate delegate;
    private IObservableValue observable;
    private CLabel label;

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = new Delegate();
        this.delegate.setUp();
        this.label = this.delegate.label;
        this.observable = this.delegate.createObservableValue(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delegate.tearDown();
        this.observable.dispose();
    }

    public void testSetValue() throws Exception {
        CLabelObservableValueTest.assertEquals(null, (String)this.label.getText());
        CLabelObservableValueTest.assertEquals(null, (Object)this.observable.getValue());
        String value = "value";
        this.observable.setValue((Object)value);
        CLabelObservableValueTest.assertEquals((String)"label text", (String)value, (String)this.label.getText());
        CLabelObservableValueTest.assertEquals((String)"observable value", (Object)value, (Object)this.observable.getValue());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(CLabelObservableValueTest.class.getName());
        suite.addTestSuite(CLabelObservableValueTest.class);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        CLabel label;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.label = new CLabel((Composite)this.shell, 0);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.text().observe(realm, (Object)this.label);
        }

        public void change(IObservable observable) {
            IObservableValue value = (IObservableValue)observable;
            value.setValue((Object)(value.getValue() + "a"));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            return observable.getValue() + "a";
        }
    }
}

