/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.ISWTObservable;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ComboObservableValueSelectionTest
extends TestCase {
    private Delegate delegate;
    private Combo combo;

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = new Delegate();
        this.delegate.setUp();
        this.combo = this.delegate.combo;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.delegate.tearDown();
    }

    public void testSelection_NotifiesObservable() throws Exception {
        IObservableValue observable = (IObservableValue)this.delegate.createObservable(DisplayRealm.getRealm((Display)Display.getDefault()));
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        this.combo.select(0);
        this.combo.notifyListeners(13, null);
        ComboObservableValueSelectionTest.assertEquals((String)"Observable was not notified.", (int)1, (int)listener.count);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ComboObservableValueSelectionTest.class.toString());
        suite.addTestSuite(ComboObservableValueSelectionTest.class);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Combo combo;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.combo = new Combo((Composite)this.shell, 0);
            this.combo.add("a");
            this.combo.add("b");
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.selection().observe(realm, (Object)this.combo);
        }

        public void change(IObservable observable) {
            int index = this.combo.indexOf((String)this.createValue((IObservableValue)observable));
            ((IObservableValue)observable).setValue((Object)this.combo.getItem(index));
        }

        public Object getValueType(IObservableValue observable) {
            return String.class;
        }

        public Object createValue(IObservableValue observable) {
            Combo combo = (Combo)((ISWTObservable)observable).getWidget();
            switch (combo.getSelectionIndex()) {
                case -1: 
                case 1: {
                    return combo.getItem(0);
                }
                case 0: {
                    return combo.getItem(1);
                }
            }
            throw new RuntimeException("Unexpected selection.");
        }
    }
}

