/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.internal.databinding.swt.ComboSelectionProperty;
import org.eclipse.jface.internal.databinding.swt.ComboTextProperty;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ComboObservableValueTest
extends AbstractSWTTestCase {
    public void testDispose() throws Exception {
        Combo combo = new Combo((Composite)this.getShell(), 0);
        ISWTObservableValue observableValue = SWTObservables.observeText((Control)combo);
        ValueChangeEventTracker testCounterValueChangeListener = new ValueChangeEventTracker();
        observableValue.addValueChangeListener((IValueChangeListener)testCounterValueChangeListener);
        ComboObservableValueTest.assertEquals((String)"", (String)combo.getText());
        ComboObservableValueTest.assertEquals((Object)"", (Object)observableValue.getValue());
        String expected1 = "Test123";
        combo.setText(expected1);
        ComboObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        ComboObservableValueTest.assertEquals((String)expected1, (String)combo.getText());
        ComboObservableValueTest.assertEquals((Object)expected1, (Object)observableValue.getValue());
        observableValue.dispose();
        String expected2 = "NewValue123";
        combo.setText(expected2);
        ComboObservableValueTest.assertEquals((int)1, (int)testCounterValueChangeListener.count);
        ComboObservableValueTest.assertEquals((String)expected2, (String)combo.getText());
    }

    public void testSetValueWithNull() {
        this.testSetValueWithNull((IValueProperty)WidgetProperties.text());
        this.testSetValueWithNull((IValueProperty)WidgetProperties.selection());
    }

    protected void testSetValueWithNull(IValueProperty property) {
        Combo combo = new Combo((Composite)this.getShell(), 0);
        combo.setItems(new String[]{"one", "two", "three"});
        IObservableValue observable = property.observe(Realm.getDefault(), (Object)combo);
        observable.setValue((Object)"two");
        ComboObservableValueTest.assertEquals((String)"two", (String)combo.getText());
        if (property instanceof ComboSelectionProperty) {
            ComboObservableValueTest.assertEquals((String)"expect selection at index 1 in selection mode", (int)1, (int)combo.getSelectionIndex());
        }
        if (property instanceof ComboTextProperty) {
            observable.setValue(null);
            ComboObservableValueTest.assertEquals((String)"expect empty text in text mode", (String)"", (String)combo.getText());
        }
    }
}

