/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

public class DateTimeCalendarObservableValueTest
extends AbstractSWTTestCase {
    private DateTime dateTime;
    private IObservableValue dateObservable;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dateTime = new DateTime((Composite)this.getShell(), 1024);
        this.dateObservable = WidgetProperties.selection().observe((Widget)this.dateTime);
    }

    public void testGetValue_ExcludesTimeComponent() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        int epochHour = calendar.get(11);
        int epochMinute = calendar.get(12);
        int epochSecond = calendar.get(13);
        int epochMillisecond = calendar.get(14);
        calendar.set(2009, 3, 3, 12, 7, 21);
        this.dateObservable.setValue((Object)calendar.getTime());
        calendar.setTime((Date)this.dateObservable.getValue());
        DateTimeCalendarObservableValueTest.assertEquals((int)2009, (int)calendar.get(1));
        DateTimeCalendarObservableValueTest.assertEquals((int)3, (int)calendar.get(2));
        DateTimeCalendarObservableValueTest.assertEquals((int)3, (int)calendar.get(5));
        DateTimeCalendarObservableValueTest.assertEquals((int)epochHour, (int)calendar.get(11));
        DateTimeCalendarObservableValueTest.assertEquals((int)epochMinute, (int)calendar.get(12));
        DateTimeCalendarObservableValueTest.assertEquals((int)epochSecond, (int)calendar.get(13));
        DateTimeCalendarObservableValueTest.assertEquals((int)epochMillisecond, (int)calendar.get(14));
    }
}

