/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class ScaleObservableValueMinTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private Scale scale;
    private IObservableValue observable;

    public ScaleObservableValueMinTest() {
        this(null);
    }

    public ScaleObservableValueMinTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.scale = this.delegate.scale;
    }

    protected IObservable doCreateObservable() {
        return this.getObservableContractDelegate().createObservable(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    public void testGetValue() throws Exception {
        int min = 100;
        this.scale.setMinimum(min);
        ScaleObservableValueMinTest.assertEquals((Object)min, (Object)this.observable.getValue());
    }

    public void testSetValue() throws Exception {
        int min = 100;
        this.observable.setValue((Object)min);
        ScaleObservableValueMinTest.assertEquals((int)min, (int)this.scale.getMinimum());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ScaleObservableValueMinTest.class.toString());
        suite.addTestSuite(ScaleObservableValueMinTest.class);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Scale scale;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.scale = new Scale((Composite)this.shell, 0);
            this.scale.setMaximum(1000);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.minimum().observe(realm, (Object)this.scale);
        }

        public void change(IObservable observable) {
            IObservableValue observableValue = (IObservableValue)observable;
            observableValue.setValue(this.createValue(observableValue));
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            return (Integer)observable.getValue() + 1;
        }
    }
}

