/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.swt;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.conformance.ObservableDelegateTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.swt.SWTMutableObservableValueContractTest;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class ScaleObservableValueSelectionTest
extends ObservableDelegateTest {
    private Delegate delegate;
    private Scale scale;
    private IObservableValue observable;

    public ScaleObservableValueSelectionTest() {
        this(null);
    }

    public ScaleObservableValueSelectionTest(String testName) {
        super(testName, (IObservableContractDelegate)new Delegate());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.delegate = (Delegate)this.getObservableContractDelegate();
        this.observable = (IObservableValue)this.getObservable();
        this.scale = this.delegate.scale;
    }

    protected IObservable doCreateObservable() {
        return this.getObservableContractDelegate().createObservable(DisplayRealm.getRealm((Display)Display.getDefault()));
    }

    public void testGetValue() throws Exception {
        int value = 100;
        this.scale.setSelection(value);
        ScaleObservableValueSelectionTest.assertEquals((Object)value, (Object)this.observable.getValue());
    }

    public void testSetValue() throws Exception {
        int value = 100;
        this.observable.setValue((Object)value);
        ScaleObservableValueSelectionTest.assertEquals((int)value, (int)this.scale.getSelection());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ScaleObservableValueSelectionTest.class.toString());
        suite.addTestSuite(ScaleObservableValueSelectionTest.class);
        suite.addTest(SWTMutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        private Shell shell;
        Scale scale;

        Delegate() {
        }

        public void setUp() {
            this.shell = new Shell();
            this.scale = new Scale((Composite)this.shell, 0);
            this.scale.setMaximum(1000);
        }

        public void tearDown() {
            this.shell.dispose();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return WidgetProperties.selection().observe(realm, (Object)this.scale);
        }

        public void change(IObservable observable) {
            this.scale.setSelection(this.createIntegerValue((IObservableValue)observable).intValue());
            this.scale.notifyListeners(13, null);
        }

        public Object getValueType(IObservableValue observable) {
            return Integer.TYPE;
        }

        public Object createValue(IObservableValue observable) {
            return this.createIntegerValue(observable);
        }

        private Integer createIntegerValue(IObservableValue observable) {
            return (Integer)observable.getValue() + 1;
        }
    }
}

