/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.DisposeEventTracker;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ObservableCollectionTreeContentProviderTest
extends AbstractDefaultRealmTestCase {
    private Shell shell;
    private TreeViewer viewer;
    ObservableListTreeContentProvider contentProvider;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
        this.viewer = new TreeViewer((Composite)this.shell);
    }

    @Override
    protected void tearDown() throws Exception {
        this.shell.dispose();
        this.shell = null;
        this.viewer = null;
        super.tearDown();
    }

    public void testGetKnownElements_ExcludesInput() {
        final Object input = new Object();
        Object[] rootElements = new Object[]{"one", "two", "three"};
        WritableList rootElementList = new WritableList(Arrays.asList(rootElements), null);
        this.contentProvider = new ObservableListTreeContentProvider(new IObservableFactory((IObservableList)rootElementList){
            private final /* synthetic */ IObservableList val$rootElementList;
            {
                this.val$rootElementList = iObservableList;
            }

            public IObservable createObservable(Object target) {
                if (target == input) {
                    return this.val$rootElementList;
                }
                return null;
            }
        }, null);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setInput(input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        ObservableCollectionTreeContentProviderTest.assertFalse((boolean)knownElements.contains(input));
        ObservableCollectionTreeContentProviderTest.assertEquals(new HashSet<Object>(Arrays.asList(rootElements)), (Object)knownElements);
    }

    public void testGetKnownElements_DisposedWithoutModificationOnContentProviderDispose() {
        final Object input = new Object();
        WritableList rootElementList = new WritableList(Collections.singletonList("element"), null);
        this.contentProvider = new ObservableListTreeContentProvider(new IObservableFactory((IObservableList)rootElementList){
            private final /* synthetic */ IObservableList val$rootElementList;
            {
                this.val$rootElementList = iObservableList;
            }

            public IObservable createObservable(Object target) {
                if (target == input) {
                    return this.val$rootElementList;
                }
                return null;
            }
        }, null);
        this.contentProvider.inputChanged((Viewer)this.viewer, null, input);
        IObservableSet knownElements = this.contentProvider.getKnownElements();
        this.contentProvider.getElements(input);
        ObservableCollectionTreeContentProviderTest.assertEquals((int)1, (int)knownElements.size());
        DisposeEventTracker disposeTracker = DisposeEventTracker.observe((IObservable)knownElements);
        ChangeEventTracker changeTracker = ChangeEventTracker.observe((IObservable)knownElements);
        this.contentProvider.dispose();
        ObservableCollectionTreeContentProviderTest.assertEquals((int)0, (int)changeTracker.count);
        ObservableCollectionTreeContentProviderTest.assertEquals((int)1, (int)disposeTracker.count);
        ObservableCollectionTreeContentProviderTest.assertTrue((boolean)knownElements.isDisposed());
    }
}

