/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementMap;
import org.eclipse.jface.viewers.IElementComparer;

public class ViewerElementMapTest
extends TestCase {
    IdentityElementComparer comparer;
    ViewerElementMap map;
    Object key;
    Object value;

    protected void setUp() throws Exception {
        super.setUp();
        this.comparer = new IdentityElementComparer();
        this.map = new ViewerElementMap((IElementComparer)this.comparer);
        this.key = new Object();
        this.value = new Object();
    }

    public void testConstructor_NullComparer() {
        try {
            new ViewerElementMap(null);
            ViewerElementMapTest.fail((String)"Constructor should throw exception when null comparer passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_NullCollection() {
        try {
            new ViewerElementMap(null, (IElementComparer)new IdentityElementComparer());
            ViewerElementMapTest.fail((String)"Constructor should throw exception when null collection passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_ContainsAllEntries() {
        HashMap<Object, Object> toCopy = new HashMap<Object, Object>();
        toCopy.put(new Object(), new Object());
        this.map = new ViewerElementMap(toCopy, (IElementComparer)new IdentityElementComparer());
        ViewerElementMapTest.assertEquals(toCopy, (Object)this.map);
    }

    public void testIsEmpty() {
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertFalse((boolean)this.map.isEmpty());
    }

    public void testSize() {
        ViewerElementMapTest.assertEquals((int)0, (int)this.map.size());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
    }

    public void testClear() {
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testGet() {
        ViewerElementMapTest.assertNull((Object)this.map.get(this.key));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((Object)this.value, (Object)this.map.get(this.key));
    }

    public void testContainsKey() {
        String key1 = new String("key");
        String key2 = new String("key");
        ViewerElementMapTest.assertFalse((boolean)this.map.containsKey((Object)key1));
        this.map.put((Object)key1, this.value);
        ViewerElementMapTest.assertTrue((boolean)this.map.containsKey((Object)key1));
        ViewerElementMapTest.assertFalse((boolean)this.map.containsKey((Object)key2));
    }

    public void testContainsValue() {
        ViewerElementMapTest.assertFalse((boolean)this.map.containsValue(this.value));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)this.map.containsValue(this.value));
    }

    public void testPutAll() {
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
        this.map.putAll(other);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertTrue((boolean)this.map.containsKey(this.key));
        ViewerElementMapTest.assertEquals((Object)this.value, (Object)this.map.get(this.key));
    }

    public void testRemove() {
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)this.map.containsKey(this.key));
        this.map.remove(this.key);
        ViewerElementMapTest.assertFalse((boolean)this.map.containsKey(this.key));
    }

    public void testValues() {
        Collection values = this.map.values();
        ViewerElementMapTest.assertTrue((boolean)values.isEmpty());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)values.size());
        ViewerElementMapTest.assertEquals((Object)this.value, values.iterator().next());
        this.map.remove(this.key);
        ViewerElementMapTest.assertTrue((boolean)this.map.values().isEmpty());
    }

    public void testKeySet() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertTrue((boolean)keySet.isEmpty());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)keySet.size());
        ViewerElementMapTest.assertTrue((boolean)keySet.contains(this.key));
        this.map.remove(this.key);
        ViewerElementMapTest.assertTrue((boolean)keySet.isEmpty());
    }

    public void testKeySet_Add() {
        try {
            this.map.keySet().add(this.key);
            ViewerElementMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testKeySet_AddAll() {
        try {
            this.map.keySet().addAll(Collections.singleton(this.key));
            ViewerElementMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testKeySet_Clear() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertTrue((boolean)keySet.contains(this.key));
        keySet.clear();
        ViewerElementMapTest.assertTrue((boolean)keySet.isEmpty());
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_Contains() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertFalse((boolean)keySet.contains(this.key));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)keySet.contains(this.key));
    }

    public void testKeySet_ContainsAll() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertFalse((boolean)keySet.containsAll(Collections.singleton(this.key)));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)keySet.containsAll(Collections.singleton(this.key)));
    }

    public void testKeySet_IsEmpty() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertTrue((boolean)keySet.isEmpty());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertFalse((boolean)keySet.isEmpty());
    }

    public void testKeySet_Iterator() {
        this.map.put(this.key, this.value);
        Iterator iterator = this.map.keySet().iterator();
        ViewerElementMapTest.assertTrue((boolean)iterator.hasNext());
        ViewerElementMapTest.assertEquals((Object)this.key, iterator.next());
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        iterator.remove();
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
        ViewerElementMapTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testKeySet_Remove() {
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        this.map.keySet().remove(this.key);
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_RemoveAll() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertFalse((boolean)keySet.removeAll(Collections.EMPTY_SET));
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertTrue((boolean)keySet.removeAll(Collections.singleton(this.key)));
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_RetainAll() {
        this.map.put(this.key, this.value);
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertFalse((boolean)keySet.retainAll(Collections.singleton(this.key)));
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertTrue((boolean)keySet.retainAll(Collections.EMPTY_SET));
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testKeySet_Size() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertEquals((int)0, (int)keySet.size());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)keySet.size());
        this.map.clear();
        ViewerElementMapTest.assertEquals((int)0, (int)keySet.size());
    }

    public void testKeySet_ToArray() {
        Set keySet = this.map.keySet();
        this.map.put(this.key, this.value);
        Object[] array = keySet.toArray();
        ViewerElementMapTest.assertEquals((int)1, (int)array.length);
        ViewerElementMapTest.assertSame((Object)this.key, (Object)array[0]);
    }

    public void testKeySet_ToArrayWithObjectArray() {
        this.key = new String("key");
        this.map.put(this.key, this.value);
        String[] array = this.map.keySet().toArray(new String[0]);
        ViewerElementMapTest.assertEquals((int)1, (int)array.length);
        ViewerElementMapTest.assertSame((Object)this.key, (Object)array[0]);
    }

    public void testKeySet_Equals() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertFalse((boolean)keySet.equals(null));
        ViewerElementMapTest.assertTrue((boolean)keySet.equals(keySet));
        ViewerElementMapTest.assertTrue((boolean)keySet.equals(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)keySet.equals(Collections.singleton(this.key)));
    }

    public void testKeySet_HashCode() {
        Set keySet = this.map.keySet();
        ViewerElementMapTest.assertEquals((int)0, (int)keySet.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key);
        ViewerElementMapTest.assertEquals((int)hash, (int)keySet.hashCode());
    }

    public void testEntrySet() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertTrue((boolean)entrySet.isEmpty());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)entrySet.size());
        Map.Entry entry = (Map.Entry)entrySet.iterator().next();
        ViewerElementMapTest.assertEquals((Object)this.key, entry.getKey());
        ViewerElementMapTest.assertEquals((Object)this.value, entry.getValue());
        this.map.remove(this.key);
        ViewerElementMapTest.assertTrue((boolean)entrySet.isEmpty());
    }

    public void testEntrySet_Add() {
        try {
            this.map.entrySet().add(this.key);
            ViewerElementMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testEntrySet_AddAll() {
        try {
            this.map.entrySet().addAll(Collections.EMPTY_SET);
            ViewerElementMapTest.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testEntrySet_Clear() {
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        this.map.entrySet().clear();
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_Contains() {
        this.map.put(this.key, this.value);
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertTrue((boolean)entrySet.contains(new MapEntryStub(this.key, this.value)));
        this.map.remove(this.key);
        ViewerElementMapTest.assertFalse((boolean)entrySet.contains(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_ContainsAll() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertFalse((boolean)entrySet.containsAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        ViewerElementMapTest.assertTrue((boolean)entrySet.containsAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)entrySet.containsAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
    }

    public void testEntrySet_IsEmpty() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertTrue((boolean)entrySet.isEmpty());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertFalse((boolean)entrySet.isEmpty());
    }

    public void testEntrySet_Iterator() {
        this.map.put(this.key, this.value);
        Iterator iterator = this.map.entrySet().iterator();
        ViewerElementMapTest.assertTrue((boolean)iterator.hasNext());
        Map.Entry entry = (Map.Entry)iterator.next();
        ViewerElementMapTest.assertTrue((boolean)entry.equals(new MapEntryStub(this.key, this.value)));
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        iterator.remove();
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
        ViewerElementMapTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testEntrySet_Remove() {
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertTrue((boolean)this.map.entrySet().remove(new MapEntryStub(this.key, this.value)));
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_RemoveAll() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertFalse((boolean)entrySet.removeAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertTrue((boolean)entrySet.removeAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_RetainAll() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertFalse((boolean)entrySet.retainAll(Collections.EMPTY_SET));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertFalse((boolean)entrySet.retainAll(Collections.singleton(new MapEntryStub(this.key, this.value))));
        ViewerElementMapTest.assertEquals((int)1, (int)this.map.size());
        ViewerElementMapTest.assertTrue((boolean)entrySet.retainAll(Collections.EMPTY_SET));
        ViewerElementMapTest.assertTrue((boolean)this.map.isEmpty());
    }

    public void testEntrySet_Size() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertEquals((int)0, (int)entrySet.size());
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertEquals((int)1, (int)entrySet.size());
    }

    public void testEntrySet_ToArray() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertEquals((int)0, (int)entrySet.toArray().length);
        this.map.put(this.key, this.value);
        Object[] array = entrySet.toArray();
        ViewerElementMapTest.assertEquals((int)1, (int)array.length);
        ViewerElementMapTest.assertTrue((boolean)array[0].equals(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_ToArrayWithObjectArray() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertEquals((int)0, (int)entrySet.toArray(new Object[0]).length);
        this.map.put(this.key, this.value);
        Map.Entry[] array = entrySet.toArray(new Map.Entry[0]);
        ViewerElementMapTest.assertEquals((int)1, (int)array.length);
        ViewerElementMapTest.assertTrue((boolean)array[0].equals(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_Equals() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertFalse((boolean)entrySet.equals(null));
        ViewerElementMapTest.assertTrue((boolean)entrySet.equals(entrySet));
        ViewerElementMapTest.assertTrue((boolean)entrySet.equals(Collections.EMPTY_SET));
        ViewerElementMapTest.assertFalse((boolean)entrySet.equals(Collections.singleton(new MapEntryStub(this.key, this.value))));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertFalse((boolean)entrySet.equals(Collections.EMPTY_SET));
        ViewerElementMapTest.assertTrue((boolean)entrySet.equals(Collections.singleton(new MapEntryStub(this.key, this.value))));
    }

    public void testEntrySet_HashCode() {
        Set entrySet = this.map.entrySet();
        ViewerElementMapTest.assertEquals((int)0, (int)entrySet.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key) ^ this.value.hashCode();
        ViewerElementMapTest.assertEquals((int)hash, (int)entrySet.hashCode());
    }

    public void testEntrySet_Entry_SetValue() {
        this.map.put(this.key, this.value);
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        Object newValue = new Object();
        Object oldValue = entry.setValue(newValue);
        ViewerElementMapTest.assertEquals((Object)this.value, (Object)oldValue);
        ViewerElementMapTest.assertEquals((Object)newValue, entry.getValue());
        ViewerElementMapTest.assertEquals((Object)newValue, (Object)this.map.get(this.key));
    }

    public void testEntrySet_Entry_Equals() {
        this.map.put(this.key, this.value);
        Map.Entry entry = (Map.Entry)this.map.entrySet().iterator().next();
        ViewerElementMapTest.assertFalse((boolean)entry.equals(null));
        ViewerElementMapTest.assertTrue((boolean)entry.equals(entry));
        ViewerElementMapTest.assertTrue((boolean)entry.equals(new MapEntryStub(this.key, this.value)));
    }

    public void testEntrySet_Entry_HashCode() {
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key) ^ this.value.hashCode();
        ViewerElementMapTest.assertEquals((int)hash, (int)this.map.entrySet().iterator().next().hashCode());
    }

    public void testEquals() {
        ViewerElementMapTest.assertFalse((boolean)this.map.equals(null));
        ViewerElementMapTest.assertTrue((boolean)this.map.equals((Object)this.map));
        HashMap<Object, Object> other = new HashMap<Object, Object>();
        other.put(this.key, this.value);
        ViewerElementMapTest.assertTrue((boolean)this.map.equals((Object)Collections.EMPTY_MAP));
        ViewerElementMapTest.assertFalse((boolean)this.map.equals(other));
        this.map.put(this.key, this.value);
        ViewerElementMapTest.assertFalse((boolean)this.map.equals((Object)Collections.EMPTY_MAP));
        ViewerElementMapTest.assertTrue((boolean)this.map.equals(other));
    }

    public void testHashCode() {
        ViewerElementMapTest.assertEquals((int)0, (int)this.map.hashCode());
        this.map.put(this.key, this.value);
        int hash = this.comparer.hashCode(this.key) ^ this.value.hashCode();
        ViewerElementMapTest.assertEquals((int)hash, (int)this.map.hashCode());
    }

    public void testWithComparer() {
        ViewerElementMapTest.assertFalse((boolean)(ViewerElementMap.withComparer(null) instanceof ViewerElementMap));
        ViewerElementMapTest.assertTrue((boolean)(ViewerElementMap.withComparer((IElementComparer)this.comparer) instanceof ViewerElementMap));
    }

    static class IdentityElementComparer
    implements IElementComparer {
        IdentityElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object element) {
            return System.identityHashCode(element);
        }
    }

    static class MapEntryStub
    implements Map.Entry {
        private final Object key;
        private final Object value;

        public MapEntryStub(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }
}

