/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.viewers.IElementComparer;

public class ViewerElementSetTest
extends TestCase {
    IdentityElementComparer comparer;
    ViewerElementSet set;

    protected void setUp() throws Exception {
        super.setUp();
        this.comparer = new IdentityElementComparer();
        this.set = new ViewerElementSet((IElementComparer)this.comparer);
    }

    public void testConstructor_NullComparer() {
        try {
            new ViewerElementSet(null);
            ViewerElementSetTest.fail((String)"Constructor should throw exception when null comparer passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_NullCollection() {
        try {
            new ViewerElementSet(null, (IElementComparer)new IdentityElementComparer());
            ViewerElementSetTest.fail((String)"Constructor should throw exception when null collection passed in");
        }
        catch (RuntimeException runtimeException) {}
    }

    public void testConstructorWithCollection_AddsAllElements() {
        Set<Object> toCopy = Collections.singleton(new Object());
        this.set = new ViewerElementSet(toCopy, (IElementComparer)new IdentityElementComparer());
        ViewerElementSetTest.assertTrue((boolean)this.set.containsAll(toCopy));
    }

    public void testAdd_ContainsHonorsComparer() {
        String o1 = new String("string");
        String o2 = new String("string");
        ViewerElementSetTest.assertTrue((boolean)o1.equals(o2));
        ViewerElementSetTest.assertNotSame((Object)o1, (Object)o2);
        ViewerElementSetTest.assertTrue((boolean)this.set.add((Object)o1));
        ViewerElementSetTest.assertTrue((boolean)this.set.contains((Object)o1));
        ViewerElementSetTest.assertFalse((boolean)this.set.contains((Object)o2));
    }

    public void testAdd_FilterDuplicateElements() {
        Object o = new Object();
        ViewerElementSetTest.assertTrue((boolean)this.set.add(o));
        ViewerElementSetTest.assertFalse((boolean)this.set.add(o));
        ViewerElementSetTest.assertEquals((int)1, (int)this.set.size());
        ViewerElementSetTest.assertTrue((boolean)this.set.contains(o));
    }

    public void testAddAll_ContainsAllHonorsComparer() {
        String o1 = new String("o1");
        String o2 = new String("o2");
        List<Object> items = Arrays.asList(o1, o2);
        ViewerElementSetTest.assertTrue((boolean)this.set.addAll(items));
        ViewerElementSetTest.assertTrue((boolean)this.set.containsAll(items));
        ViewerElementSetTest.assertFalse((boolean)this.set.containsAll(Collections.singleton(new String("o1"))));
        ViewerElementSetTest.assertFalse((boolean)this.set.containsAll(Collections.singleton(new String("o2"))));
    }

    public void testAddAll_FiltersDuplicateElements() {
        Object o = new Object();
        this.set.add(o);
        ViewerElementSetTest.assertFalse((boolean)this.set.addAll(Collections.singleton(o)));
    }

    public void testClear() {
        this.set.add(new Object());
        ViewerElementSetTest.assertEquals((int)1, (int)this.set.size());
        this.set.clear();
        ViewerElementSetTest.assertEquals((int)0, (int)this.set.size());
    }

    public void testIsEmpty() {
        ViewerElementSetTest.assertTrue((boolean)this.set.isEmpty());
        this.set.add(new Object());
        ViewerElementSetTest.assertFalse((boolean)this.set.isEmpty());
    }

    public void testIterator() {
        Object o = new Object();
        this.set.add(o);
        Iterator iterator = this.set.iterator();
        ViewerElementSetTest.assertTrue((boolean)iterator.hasNext());
        ViewerElementSetTest.assertSame((Object)o, iterator.next());
        ViewerElementSetTest.assertTrue((boolean)this.set.contains(o));
        iterator.remove();
        ViewerElementSetTest.assertFalse((boolean)this.set.contains(o));
        ViewerElementSetTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testRemove() {
        Object o = new Object();
        ViewerElementSetTest.assertFalse((boolean)this.set.remove(o));
        ViewerElementSetTest.assertTrue((boolean)this.set.add(o));
        ViewerElementSetTest.assertTrue((boolean)this.set.contains(o));
        ViewerElementSetTest.assertTrue((boolean)this.set.remove(o));
        ViewerElementSetTest.assertFalse((boolean)this.set.contains(o));
    }

    public void testRemoveAll() {
        ViewerElementSetTest.assertFalse((boolean)this.set.removeAll((Collection)Collections.EMPTY_SET));
        Object o1 = new Object();
        Object o2 = new Object();
        this.set.addAll(Arrays.asList(o1, o2));
        ViewerElementSetTest.assertTrue((boolean)this.set.removeAll(Collections.singleton(o1)));
        ViewerElementSetTest.assertFalse((boolean)this.set.contains(o1));
        ViewerElementSetTest.assertFalse((boolean)this.set.removeAll(Collections.singleton(o1)));
        ViewerElementSetTest.assertTrue((boolean)this.set.removeAll(Arrays.asList(o2, "some", "other", "objects")));
        ViewerElementSetTest.assertFalse((boolean)this.set.contains(o2));
    }

    public void testRetainAll() {
        Object o1 = new Object();
        Object o2 = new Object();
        this.set.add(o1);
        this.set.add(o2);
        ViewerElementSetTest.assertFalse((boolean)this.set.retainAll(Arrays.asList(o1, o2)));
        ViewerElementSetTest.assertTrue((boolean)this.set.contains(o2));
        ViewerElementSetTest.assertTrue((boolean)this.set.retainAll(Collections.singleton(o1)));
        ViewerElementSetTest.assertFalse((boolean)this.set.contains(o2));
        ViewerElementSetTest.assertTrue((boolean)this.set.contains(o1));
        ViewerElementSetTest.assertTrue((boolean)this.set.retainAll((Collection)Collections.EMPTY_SET));
        ViewerElementSetTest.assertFalse((boolean)this.set.contains(o1));
    }

    public void testSize() {
        ViewerElementSetTest.assertEquals((int)0, (int)this.set.size());
        Object o = new Object();
        this.set.add(o);
        ViewerElementSetTest.assertEquals((int)1, (int)this.set.size());
        this.set.remove(o);
        ViewerElementSetTest.assertEquals((int)0, (int)this.set.size());
    }

    public void testToArray() {
        ViewerElementSetTest.assertEquals((int)0, (int)this.set.toArray().length);
        Object o = new Object();
        this.set.add(o);
        ViewerElementSetTest.assertTrue((boolean)Arrays.equals(new Object[]{o}, this.set.toArray()));
    }

    public void testToArrayWithObjectArray() {
        String o = new String("unique");
        this.set.add((Object)o);
        String[] array = (String[])this.set.toArray((Object[])new String[0]);
        ViewerElementSetTest.assertEquals((int)1, (int)array.length);
        ViewerElementSetTest.assertSame((Object)o, (Object)array[0]);
    }

    public void testEquals() {
        ViewerElementSetTest.assertTrue((boolean)this.set.equals((Object)this.set));
        ViewerElementSetTest.assertFalse((boolean)this.set.equals(null));
        ViewerElementSetTest.assertFalse((boolean)this.set.equals(new Object()));
        ViewerElementSetTest.assertTrue((boolean)this.set.equals((Object)Collections.EMPTY_SET));
        String o = new String("string");
        String distinct = new String("string");
        this.set.add((Object)o);
        ViewerElementSetTest.assertTrue((boolean)this.set.equals(Collections.singleton(o)));
        ViewerElementSetTest.assertFalse((boolean)this.set.equals(Collections.singleton(distinct)));
    }

    public void testHashCode() {
        ViewerElementSetTest.assertEquals((int)0, (int)this.set.hashCode());
        Object o = new Object();
        this.set.add(o);
        int hash = this.comparer.hashCode(o);
        ViewerElementSetTest.assertEquals((int)hash, (int)this.set.hashCode());
        Object o2 = new Object();
        this.set.add(o2);
        ViewerElementSetTest.assertEquals((int)(hash += this.comparer.hashCode(o2)), (int)this.set.hashCode());
    }

    static class IdentityElementComparer
    implements IElementComparer {
        IdentityElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }

        public int hashCode(Object element) {
            return System.identityHashCode(element);
        }
    }
}

