/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.conformance.MutableObservableValueContractTest;
import org.eclipse.jface.databinding.conformance.delegate.AbstractObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.delegate.IObservableValueContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ValueChangeEventTracker;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.tests.databinding.AbstractDefaultRealmTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ViewerInputObservableValueTest
extends AbstractDefaultRealmTestCase {
    private TableViewer viewer;
    private static String[] model = new String[]{"0", "1"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Shell shell = new Shell();
        this.viewer = new TableViewer((Composite)shell, 0);
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
    }

    @Override
    protected void tearDown() throws Exception {
        Shell shell = this.viewer.getTable().getShell();
        if (!shell.isDisposed()) {
            shell.dispose();
        }
        super.tearDown();
    }

    public void testConstructor_IllegalArgumentException() {
        try {
            ViewersObservables.observeInput(null);
            ViewerInputObservableValueTest.fail((String)"Expected IllegalArgumentException for null argument");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testSetInputOnViewer_FiresChangeEventOnGetValue() {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        ValueChangeEventTracker listener = ValueChangeEventTracker.observe((IObservableValue)observable);
        ViewerInputObservableValueTest.assertNull((Object)this.viewer.getInput());
        ViewerInputObservableValueTest.assertEquals((int)0, (int)listener.count);
        this.viewer.setInput((Object)model);
        ViewerInputObservableValueTest.assertEquals((Object)model, (Object)this.viewer.getInput());
        ViewerInputObservableValueTest.assertEquals((int)0, (int)listener.count);
        ViewerInputObservableValueTest.assertEquals((Object)model, (Object)observable.getValue());
        ViewerInputObservableValueTest.assertEquals((int)1, (int)listener.count);
        this.viewer.setInput(null);
        ViewerInputObservableValueTest.assertEquals(null, (Object)this.viewer.getInput());
        ViewerInputObservableValueTest.assertEquals(null, (Object)observable.getValue());
        ViewerInputObservableValueTest.assertEquals((int)2, (int)listener.count);
    }

    public void testGetSetValue_FiresChangeEvents() {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        ValueChangeEventTracker listener = new ValueChangeEventTracker();
        observable.addValueChangeListener((IValueChangeListener)listener);
        ViewerInputObservableValueTest.assertNull((Object)observable.getValue());
        ViewerInputObservableValueTest.assertEquals((int)0, (int)listener.count);
        observable.setValue((Object)model);
        ViewerInputObservableValueTest.assertEquals((Object)model, (Object)observable.getValue());
        ViewerInputObservableValueTest.assertEquals((int)1, (int)listener.count);
        this.assertValueChangeEventEquals(observable, null, model, listener.event);
        observable.setValue(null);
        ViewerInputObservableValueTest.assertNull((Object)observable.getValue());
        ViewerInputObservableValueTest.assertEquals((int)2, (int)listener.count);
        this.assertValueChangeEventEquals(observable, model, null, listener.event);
    }

    public void testGetValueType_AlwaysNull() throws Exception {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        ViewerInputObservableValueTest.assertEquals(null, (Object)observable.getValueType());
    }

    public void testDispose() throws Exception {
        IObservableValue observable = ViewersObservables.observeInput((Viewer)this.viewer);
        observable.dispose();
        try {
            observable.setValue((Object)model);
            ViewerInputObservableValueTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void assertValueChangeEventEquals(IObservableValue expectedObservable, Object expectedOldValue, Object expectedNewValue, ValueChangeEvent event) {
        ViewerInputObservableValueTest.assertSame((Object)expectedObservable, (Object)event.getObservableValue());
        ViewerInputObservableValueTest.assertEquals((Object)expectedOldValue, (Object)event.diff.getOldValue());
        ViewerInputObservableValueTest.assertEquals((Object)expectedNewValue, (Object)event.diff.getNewValue());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ViewerInputObservableValueTest.class.getName());
        suite.addTestSuite(ViewerInputObservableValueTest.class);
        suite.addTest(MutableObservableValueContractTest.suite((IObservableValueContractDelegate)new Delegate()));
        return suite;
    }

    static class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }
    }

    static class Delegate
    extends AbstractObservableValueContractDelegate {
        TableViewer viewer;

        Delegate() {
        }

        public void setUp() {
            super.setUp();
            Shell shell = new Shell();
            this.viewer = new TableViewer((Composite)shell, 0);
            this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        }

        public void tearDown() {
            Shell shell = this.viewer.getTable().getShell();
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            super.tearDown();
        }

        public IObservableValue createObservableValue(Realm realm) {
            return ViewerProperties.input().observe(realm, (Object)this.viewer);
        }

        public void change(IObservable observable) {
            IObservableValue value = (IObservableValue)observable;
            value.setValue(this.createValue(value));
        }

        public Object createValue(IObservableValue observable) {
            return new String[]{"one", "two"};
        }

        public Object getValueType(IObservableValue observable) {
            return null;
        }
    }
}

