/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.tests.internal.databinding.viewers;

import java.util.Arrays;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.tests.databinding.AbstractSWTTestCase;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.junit.Assert;

public class ViewerUpdaterTest
extends AbstractSWTTestCase {
    IObservableList<String> elementsList;
    String[] elements = new String[]{"one", "two", "three"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.elementsList = new WritableList(Arrays.asList(this.elements), String.class);
    }

    public void testTableViewer_ReplacingSelectedItemSelectsNewItem() {
        TableViewer tableViewer = new TableViewer((Composite)this.getShell());
        tableViewer.setComparator(new ViewerComparator());
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        tableViewer.setInput(this.elementsList);
        tableViewer.getTable().selectAll();
        this.elementsList.set(0, (Object)"foo");
        IStructuredSelection selection = tableViewer.getStructuredSelection();
        Assert.assertEquals((long)this.elements.length, (long)selection.size());
        Assert.assertTrue((boolean)selection.toList().contains("foo"));
    }

    public void testTreeViewer_ReplacingSelectedItemSelectsNewItem() {
        TreeViewer treeViewer = new TreeViewer((Composite)this.getShell());
        Object input = new Object();
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(target -> target == input ? this.elementsList : null, null);
        treeViewer.setComparator(new ViewerComparator());
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        treeViewer.setInput(input);
        treeViewer.getTree().selectAll();
        this.elementsList.set(0, (Object)"foo");
        ITreeSelection selection = treeViewer.getStructuredSelection();
        Assert.assertEquals((long)this.elements.length, (long)selection.size());
        Assert.assertTrue((boolean)selection.toList().contains("foo"));
    }
}

