/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.tests;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.tests.AbstractUndoManagerTest;
import org.eclipse.text.undo.DocumentUndoEvent;
import org.eclipse.text.undo.DocumentUndoManager;
import org.eclipse.text.undo.IDocumentUndoListener;
import org.eclipse.text.undo.IDocumentUndoManager;
import org.junit.Assert;
import org.junit.Test;

public class TextViewerUndoManagerTest
extends AbstractUndoManagerTest {
    @Override
    protected IUndoManager createUndoManager(int maxUndoLevel) {
        return new TextViewerUndoManager(maxUndoLevel);
    }

    public void internalTestTransferNonTextOp(final boolean isUndoable) throws Exception {
        Object context = new Object();
        DocumentUndoManager tempUndoManager = new DocumentUndoManager((IDocument)new Document());
        tempUndoManager.connect(context);
        AbstractOperation operation = new AbstractOperation(""){

            public boolean canUndo() {
                return isUndoable;
            }

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return Status.OK_STATUS;
            }
        };
        operation.addContext(tempUndoManager.getUndoContext());
        OperationHistoryFactory.getOperationHistory().add((IUndoableOperation)operation);
        Assert.assertEquals((Object)isUndoable, (Object)tempUndoManager.undoable());
        DocumentUndoManager undoManager = new DocumentUndoManager((IDocument)new Document());
        Object newContext = new Object();
        undoManager.connect(newContext);
        undoManager.addDocumentUndoListener(new IDocumentUndoListener(){

            public void documentUndoNotification(DocumentUndoEvent event) {
                Assert.fail();
            }
        });
        undoManager.transferUndoHistory((IDocumentUndoManager)tempUndoManager);
        tempUndoManager.disconnect(context);
        Assert.assertEquals((Object)isUndoable, (Object)undoManager.undoable());
        undoManager.undo();
        Assert.assertEquals((Object)false, (Object)undoManager.undoable());
        undoManager.disconnect(newContext);
    }

    @Test
    public void testTransferNonUndoableNonTextOp() throws Exception {
        this.internalTestTransferNonTextOp(false);
    }

    @Test
    public void testTransferUndoableNonTextOp() throws Exception {
        this.internalTestTransferNonTextOp(true);
    }

    @Test
    public void testCanUndo() throws Exception {
        Document doc = new Document();
        final DocumentUndoManager undoManager = new DocumentUndoManager((IDocument)doc);
        Object context = new Object();
        undoManager.connect(context);
        undoManager.addDocumentUndoListener(new IDocumentUndoListener(){

            public void documentUndoNotification(DocumentUndoEvent event) {
                if (event.getEventType() == 1) {
                    Assert.assertEquals((Object)true, (Object)undoManager.undoable());
                } else if (event.getEventType() == 4) {
                    Assert.assertEquals((Object)false, (Object)undoManager.undoable());
                }
            }
        });
        doc.set("foo");
        Assert.assertEquals((Object)true, (Object)undoManager.undoable());
        undoManager.undo();
        Assert.assertEquals((Object)false, (Object)undoManager.undoable());
        undoManager.disconnect(context);
    }
}

