/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.tests;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class FileSystemHelper {
    protected static int nextLocationCounter = 0;
    private static final long MASK = 0xFFFFFFFFL;

    public static IPath getTempDir() {
        String tempPath = System.getProperty("java.io.tmpdir");
        try {
            tempPath = new File(tempPath).getCanonicalPath();
        }
        catch (IOException iOException) {}
        return new Path(tempPath);
    }

    public static IPath getRandomLocation(IPath parent) {
        IPath path = FileSystemHelper.computeRandomLocation(parent);
        while (path.toFile().exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
            path = FileSystemHelper.computeRandomLocation(parent);
        }
        return path;
    }

    public static IPath computeRandomLocation(IPath parent) {
        long segment = (long)(++nextLocationCounter) << 32 | System.currentTimeMillis() & 0xFFFFFFFFL;
        return parent.append(Long.toString(segment));
    }
}

