/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.log.test;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.equinox.log.test.TestListener;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class LogReaderServiceTest
extends AbstractBundleTests {
    private LogService log;
    private ServiceReference logReference;
    private LogReaderService reader;
    private ServiceReference readerReference;

    public LogReaderServiceTest(String name) {
        this.setName(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.logReference = OSGiTestsActivator.getContext().getServiceReference(LogService.class.getName());
        this.readerReference = OSGiTestsActivator.getContext().getServiceReference(LogReaderService.class.getName());
        this.log = (LogService)OSGiTestsActivator.getContext().getService(this.logReference);
        this.reader = (LogReaderService)OSGiTestsActivator.getContext().getService(this.readerReference);
    }

    @Override
    protected void tearDown() throws Exception {
        OSGiTestsActivator.getContext().ungetService(this.logReference);
        OSGiTestsActivator.getContext().ungetService(this.readerReference);
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testaddListener() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        TestListener testListener = listener;
        synchronized (testListener) {
            this.log.log(3, "info");
            listener.waitForLogEntry();
        }
        LogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testaddListenerTwice() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        this.reader.addLogListener((LogListener)listener);
        TestListener testListener = listener;
        synchronized (testListener) {
            this.log.log(3, "info");
            listener.waitForLogEntry();
        }
        LogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    public void testaddNullListener() throws Exception {
        try {
            this.reader.addLogListener(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        LogReaderServiceTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBadListener() throws Exception {
        LogListener listener = new LogListener(){

            public synchronized void logged(LogEntry entry) {
                this.notifyAll();
                throw new RuntimeException("Expected error for testBadListener.");
            }
        };
        this.reader.addLogListener(listener);
        LogListener logListener = listener;
        synchronized (logListener) {
            this.log.log(3, "info");
            listener.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogEntry() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        long timeBeforeLog = System.currentTimeMillis();
        TestListener testListener = listener;
        synchronized (testListener) {
            this.log.log(this.logReference, 3, "info", new Throwable("test"));
            listener.waitForLogEntry();
        }
        ExtendedLogEntry entry = listener.getEntryX();
        LogReaderServiceTest.assertTrue((entry.getBundle() == OSGiTestsActivator.getContext().getBundle() ? 1 : 0) != 0);
        LogReaderServiceTest.assertTrue((boolean)entry.getMessage().equals("info"));
        LogReaderServiceTest.assertTrue((boolean)entry.getException().getMessage().equals("test"));
        LogReaderServiceTest.assertTrue((entry.getServiceReference() == this.logReference ? 1 : 0) != 0);
        LogReaderServiceTest.assertTrue((entry.getTime() >= timeBeforeLog ? 1 : 0) != 0);
        LogReaderServiceTest.assertTrue((entry.getLevel() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogBundleEventInfo() throws Exception {
        Bundle testBundle = installer.installBundle("test.logging.a");
        TestListener listener = new TestListener(testBundle);
        this.reader.addLogListener((LogListener)listener);
        TestListener testListener = listener;
        synchronized (testListener) {
            testBundle.start();
            listener.waitForLogEntry();
        }
        LogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogServiceEventInfo() throws Exception {
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        TestListener testListener = listener;
        synchronized (testListener) {
            OSGiTestsActivator.getContext().registerService(Object.class.getName(), new Object(), null);
            listener.waitForLogEntry();
        }
        LogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogServiceEventDebug() throws Exception {
        ServiceRegistration registration = OSGiTestsActivator.getContext().registerService(Object.class.getName(), new Object(), null);
        TestListener listener = new TestListener();
        this.reader.addLogListener((LogListener)listener);
        TestListener testListener = listener;
        synchronized (testListener) {
            registration.setProperties(new Hashtable());
            listener.waitForLogEntry();
        }
        LogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 4 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLogFrameworkEvent() throws Exception {
        Bundle testBundle = installer.installBundle("test.logging.a");
        TestListener listener = new TestListener(testBundle);
        this.reader.addLogListener((LogListener)listener);
        TestListener testListener = listener;
        synchronized (testListener) {
            installer.refreshPackages(new Bundle[]{testBundle});
            listener.waitForLogEntry();
        }
        LogReaderServiceTest.assertTrue((listener.getEntryX().getLevel() == 3 ? 1 : 0) != 0);
    }

    public void testLogHistory1() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        configuration.put("equinox.log.history.max", "10");
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        try {
            LogService testLog = (LogService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogService.class));
            LogReaderService testReader = (LogReaderService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogReaderService.class));
            LogReaderServiceTest.assertEquals((String)"Expecting no logs.", (int)0, (int)this.countLogEntries(testReader.getLog(), 0));
            int i = 0;
            while (i < 9) {
                testLog.log(2, String.valueOf(i));
                ++i;
            }
            LogReaderServiceTest.assertEquals((String)"Wrong number of logs.", (int)9, (int)this.countLogEntries(testReader.getLog(), 8));
            i = 9;
            while (i < 18) {
                testLog.log(2, String.valueOf(i));
                ++i;
            }
            LogReaderServiceTest.assertEquals((String)"Wrong number of logs.", (int)10, (int)this.countLogEntries(testReader.getLog(), 17));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
            }
            catch (BundleException bundleException) {}
            throw throwable;
        }
        try {
            equinox.stop();
        }
        catch (BundleException bundleException) {}
    }

    public void testLogHistory2() throws BundleException {
        File config = OSGiTestsActivator.getContext().getDataFile(this.getName());
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("org.osgi.framework.storage", config.getAbsolutePath());
        Equinox equinox = new Equinox(configuration);
        equinox.start();
        try {
            LogService testLog = (LogService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogService.class));
            LogReaderService testReader = (LogReaderService)equinox.getBundleContext().getService(equinox.getBundleContext().getServiceReference(LogReaderService.class));
            LogReaderServiceTest.assertEquals((String)"Expecting no logs.", (int)0, (int)this.countLogEntries(testReader.getLog(), 0));
            int i = 0;
            while (i < 9) {
                testLog.log(2, String.valueOf(i));
                ++i;
            }
            LogReaderServiceTest.assertEquals((String)"Wrong number of logs.", (int)0, (int)this.countLogEntries(testReader.getLog(), 0));
        }
        catch (Throwable throwable) {
            try {
                equinox.stop();
            }
            catch (BundleException bundleException) {}
            throw throwable;
        }
        try {
            equinox.stop();
        }
        catch (BundleException bundleException) {}
    }

    private int countLogEntries(Enumeration logEntries, int startingMessage) {
        int count = 0;
        while (logEntries.hasMoreElements()) {
            LogEntry entry = (LogEntry)logEntries.nextElement();
            LogReaderServiceTest.assertEquals((String)"Wrong log message.", (String)String.valueOf(startingMessage), (String)entry.getMessage());
            --startingMessage;
            ++count;
        }
        return count;
    }
}

