/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.io.IOException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundleExceptionTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(BundleExceptionTests.class);
    }

    public void testInvalidBundleActivator01() throws BundleException {
        Bundle error1 = installer.installBundle("activator.error1");
        try {
            error1.start();
            BundleExceptionTests.fail((String)"Expected a start failure on invalid activator");
        }
        catch (BundleException e) {
            BundleExceptionTests.assertEquals((String)"Expected activator error", (int)5, (int)e.getType());
        }
    }

    public void testInvalidBundleActivator02() throws BundleException {
        Bundle error1 = installer.installBundle("activator.error2");
        try {
            error1.start();
            BundleExceptionTests.fail((String)"Expected a start failure on invalid activator");
        }
        catch (BundleException e) {
            BundleExceptionTests.assertEquals((String)"Expected activator error", (int)5, (int)e.getType());
        }
    }

    public void testInvalidBundleActivator03() throws BundleException {
        Bundle error1 = installer.installBundle("activator.error3");
        error1.start();
        try {
            error1.stop();
            BundleExceptionTests.fail((String)"Expected a stop failure on invalid activator");
        }
        catch (BundleException e) {
            BundleExceptionTests.assertEquals((String)"Expected activator error", (int)5, (int)e.getType());
        }
    }

    public void testDuplicateError01() throws BundleException {
        installer.installBundle("activator.error1");
        try {
            installer.installBundle("activator.error4");
            BundleExceptionTests.fail((String)"Expected an install failure on duplicate bundle");
        }
        catch (BundleException e) {
            BundleExceptionTests.assertEquals((String)"Expected duplicate error", (int)9, (int)e.getType());
        }
    }

    public void testDuplicateError02() throws BundleException {
        installer.installBundle("activator.error1");
        Bundle error2 = installer.installBundle("activator.error2");
        try {
            URL updateURL = new URL(installer.getBundleLocation("activator.error4"));
            error2.update(updateURL.openStream());
            BundleExceptionTests.fail((String)"Expected an update failure on duplicate bundle");
        }
        catch (BundleException e) {
            BundleExceptionTests.assertEquals((String)"Expected duplicate error", (int)9, (int)e.getType());
        }
        catch (IOException e) {
            BundleExceptionTests.fail((String)"Unexpected io exception updating", (Throwable)e);
        }
    }

    public void testUninstallSystemBundle() {
        Bundle systemBundle = OSGiTestsActivator.getContext().getBundle(0L);
        BundleExceptionTests.assertNotNull((String)"System Bundle is null!!", (Object)systemBundle);
        try {
            systemBundle.uninstall();
            BundleExceptionTests.fail((String)"Expected error on uninstall of system bundle");
        }
        catch (BundleException e) {
            BundleExceptionTests.assertEquals((String)"Expected invalid error", (int)2, (int)e.getType());
        }
    }
}

