/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class ExtensionBundleTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(ExtensionBundleTests.class);
    }

    public void testFrameworkExtension01() throws Exception {
        Bundle fwkext = installer.installBundle("ext.framework.a", false);
        Bundle importer = installer.installBundle("ext.framework.a.importer");
        installer.resolveBundles(new Bundle[]{fwkext, importer});
        importer.start();
        importer.stop();
        Object[] results = simpleResults.getResults(2);
        ExtensionBundleTests.assertTrue((String)"1.0", (results.length == 2 ? 1 : 0) != 0);
        ExtensionBundleTests.assertEquals("1.1", "success", results[0]);
        ExtensionBundleTests.assertEquals("1.2", "success", results[1]);
    }

    public void testFrameworkExtension02() throws Exception {
        Bundle fwkext = installer.installBundle("ext.framework.a", false);
        Bundle importer = installer.installBundle("ext.framework.a.requires");
        installer.resolveBundles(new Bundle[]{fwkext, importer});
        importer.start();
        importer.stop();
        Object[] results = simpleResults.getResults(2);
        ExtensionBundleTests.assertTrue((String)"1.0", (results.length == 2 ? 1 : 0) != 0);
        ExtensionBundleTests.assertEquals("1.1", "success", results[0]);
        ExtensionBundleTests.assertEquals("1.2", "success", results[1]);
    }

    public void testExtClasspathExtension01() throws Exception {
        Bundle fwkext = installer.installBundle("ext.extclasspath.a", false);
        Bundle importer = installer.installBundle("ext.extclasspath.a.importer");
        installer.resolveBundles(new Bundle[]{fwkext, importer});
        importer.start();
        importer.stop();
        Object[] results = simpleResults.getResults(2);
        ExtensionBundleTests.assertTrue((String)"1.0", (results.length == 2 ? 1 : 0) != 0);
        ExtensionBundleTests.assertEquals("1.1", "success", results[0]);
        ExtensionBundleTests.assertEquals("1.2", "success", results[1]);
    }

    public void testExtensionBundleWithRequireCapabilityOsgiEeInstalls() {
        Bundle b = null;
        try {
            b = installer.installBundle("ext.framework.osgiee.b", false);
        }
        catch (BundleException e) {
            ExtensionBundleTests.fail((String)"Extension bundle with Require-Capability only in osgi.ee. namespace failed to install", (Throwable)e);
        }
        ExtensionBundleTests.assertTrue((String)("Could not resolve bundle: " + b), (boolean)installer.resolveBundles(new Bundle[]{b}));
        BundleWiring wiring = (BundleWiring)b.adapt(BundleWiring.class);
        ExtensionBundleTests.assertNotNull((String)("No wiring for bundle: " + b), (Object)wiring);
        List allRequired = wiring.getRequiredWires(null);
        ExtensionBundleTests.assertEquals((String)("Wrong number of wires: " + allRequired), (int)2, (int)allRequired.size());
        BundleWire hostWire = (BundleWire)wiring.getRequiredWires("osgi.wiring.host").get(0);
        ExtensionBundleTests.assertEquals((String)("Wrong provider for host: " + hostWire.getProvider().getBundle()), (long)0L, (long)hostWire.getProvider().getBundle().getBundleId());
        BundleWire eeWire = (BundleWire)wiring.getRequiredWires("osgi.ee").get(0);
        ExtensionBundleTests.assertEquals((String)("Wrong provider for osgi.ee: " + eeWire.getProvider().getBundle()), (long)0L, (long)eeWire.getProvider().getBundle().getBundleId());
    }

    public void testExtensionBundleWithRequireCapabilityOtherThanOsgiEeFailsToInstall() {
        try {
            installer.installBundle("ext.framework.osgiee.a");
            ExtensionBundleTests.fail((String)"Extension bundle with Require-Capability not in osgi.ee namespace did not fail to install");
        }
        catch (BundleException e) {
            ExtensionBundleTests.assertTrue((boolean)e.getMessage().equals(NLS.bind((String)Msg.OSGiManifestBuilderFactory_ExtensionReqCapError, (Object)"osgi.wiring.package")));
        }
    }
}

