/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.bundles;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionConstraint;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.AbstractBundleTests;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.FrameworkWiring;

public class PlatformAdminBundleTests
extends AbstractBundleTests {
    public static Test suite() {
        return new TestSuite(PlatformAdminBundleTests.class);
    }

    public void testInstallUninstallBundle() throws BundleException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        BundleDescription testDesc = systemState.getBundleByLocation(installer.getBundleLocation("test"));
        PlatformAdminBundleTests.assertNull((String)"Should not find bundle.", (Object)testDesc);
        Bundle test = installer.installBundle("test");
        testDesc = systemState.getBundleByLocation(installer.getBundleLocation("test"));
        PlatformAdminBundleTests.assertNotNull((String)"Should find bundle.", (Object)testDesc);
        test.uninstall();
        testDesc = systemState.getBundleByLocation(installer.getBundleLocation("test"));
        PlatformAdminBundleTests.assertNull((String)"Should not find bundle.", (Object)testDesc);
    }

    public void testResolveRefresh() throws BundleException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle chainTestD = installer.installBundle("chain.test.d");
        PlatformAdminBundleTests.assertTrue((String)"Could not resolve bundles.", (boolean)((FrameworkWiring)this.getContext().getBundle(0L).adapt(FrameworkWiring.class)).resolveBundles(Arrays.asList(chainTestA, chainTestB, chainTestC, chainTestD)));
        BundleDescription testADesc = systemState.getBundle(chainTestA.getBundleId());
        BundleDescription testBDesc = systemState.getBundle(chainTestB.getBundleId());
        BundleDescription testCDesc = systemState.getBundle(chainTestC.getBundleId());
        BundleDescription testDDesc = systemState.getBundle(chainTestD.getBundleId());
        PlatformAdminBundleTests.assertNotNull((String)"testADesc null!!", (Object)testADesc);
        PlatformAdminBundleTests.assertNotNull((String)"testBDesc null!!", (Object)testBDesc);
        PlatformAdminBundleTests.assertNotNull((String)"testCDesc null!!", (Object)testCDesc);
        PlatformAdminBundleTests.assertNotNull((String)"testDDesc null!!", (Object)testDDesc);
        PlatformAdminBundleTests.assertTrue((String)"testADesc is not resolved!!", (boolean)testADesc.isResolved());
        PlatformAdminBundleTests.assertTrue((String)"testBDesc is not resolved!!", (boolean)testBDesc.isResolved());
        PlatformAdminBundleTests.assertTrue((String)"testCDesc is not resolved!!", (boolean)testCDesc.isResolved());
        PlatformAdminBundleTests.assertTrue((String)"testCDesc is not resolved!!", (boolean)testDDesc.isResolved());
        chainTestD.uninstall();
        installer.refreshPackages(new Bundle[]{chainTestD});
        if (testADesc.isResolved()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                PlatformAdminBundleTests.fail((String)"Test got interrupted.", (Throwable)e);
            }
        }
        PlatformAdminBundleTests.assertFalse((String)"testADesc is resolved!!", (boolean)testADesc.isResolved());
        PlatformAdminBundleTests.assertFalse((String)"testBDesc is resolved!!", (boolean)testBDesc.isResolved());
        PlatformAdminBundleTests.assertFalse((String)"testCDesc is resolved!!", (boolean)testCDesc.isResolved());
    }

    public void disableTestUnresolvedLeaves01() throws Exception {
        Bundle chainTestA = installer.installBundle("chain.test.a");
        Bundle chainTestB = installer.installBundle("chain.test.b");
        Bundle chainTestC = installer.installBundle("chain.test.c");
        Bundle[] allBundles = new Bundle[]{chainTestA, chainTestB, chainTestC};
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        BundleDescription testADesc = systemState.getBundle(chainTestA.getBundleId());
        BundleDescription testBDesc = systemState.getBundle(chainTestB.getBundleId());
        BundleDescription testCDesc = systemState.getBundle(chainTestC.getBundleId());
        PlatformAdminBundleTests.assertNotNull((String)"testADesc null!!", (Object)testADesc);
        PlatformAdminBundleTests.assertNotNull((String)"testBDesc null!!", (Object)testBDesc);
        PlatformAdminBundleTests.assertNotNull((String)"testCDesc null!!", (Object)testCDesc);
        installer.resolveBundles(allBundles);
        PlatformAdminBundleTests.assertFalse((String)"testADesc is resolved!!", (boolean)testADesc.isResolved());
        PlatformAdminBundleTests.assertFalse((String)"testBDesc is resolved!!", (boolean)testBDesc.isResolved());
        PlatformAdminBundleTests.assertFalse((String)"testCDesc is resolved!!", (boolean)testCDesc.isResolved());
        VersionConstraint[] unsatifiedLeaves = pa.getStateHelper().getUnsatisfiedLeaves(new BundleDescription[]{testADesc});
        PlatformAdminBundleTests.assertNotNull((String)"Unsatified constraints is null!!", (Object)unsatifiedLeaves);
        PlatformAdminBundleTests.assertEquals((String)"Wrong number of constraints!!", (int)2, (int)unsatifiedLeaves.length);
        int i = 0;
        while (i < unsatifiedLeaves.length) {
            PlatformAdminBundleTests.assertTrue((String)("Constraint type is not import package: " + unsatifiedLeaves[i]), (boolean)(unsatifiedLeaves[i] instanceof ImportPackageSpecification));
            PlatformAdminBundleTests.assertEquals((String)("Package name is wrong: " + i), (String)"chain.test.d", (String)unsatifiedLeaves[i].getName());
            if (unsatifiedLeaves[i].getBundle() != testBDesc && unsatifiedLeaves[i].getBundle() != testCDesc) {
                PlatformAdminBundleTests.fail((String)("Wrong bundle for the constraint: " + unsatifiedLeaves[i].getBundle()));
            }
            ++i;
        }
    }

    public void testR3Bundle() throws BundleException, InvalidSyntaxException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        BundleInstaller r3Installer = new BundleInstaller("test_files/platformAdmin", OSGiTestsActivator.getContext());
        try {
            Bundle b = r3Installer.installBundle("b1");
            BundleDescription bDesc = systemState.getBundle(b.getBundleId());
            PlatformAdminBundleTests.assertNotNull((String)"No bundle description.", (Object)bDesc);
            ExportPackageDescription[] exports = bDesc.getExportPackages();
            ImportPackageSpecification[] imports = bDesc.getImportPackages();
            PlatformAdminBundleTests.assertEquals((String)"Wrong number of exports", (int)1, (int)exports.length);
            PlatformAdminBundleTests.assertEquals((String)"Wrong number of imports.", (int)2, (int)imports.length);
        }
        finally {
            r3Installer.shutdown();
        }
    }

    public void testNativeCodeFilterWithSpecialChars() throws BundleException, InterruptedException {
        final AtomicReference error = new AtomicReference();
        final CountDownLatch errorCnt = new CountDownLatch(1);
        FrameworkListener errorListener = new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 2) {
                    error.set(event);
                    errorCnt.countDown();
                }
            }
        };
        this.getContext().addFrameworkListener(errorListener);
        try {
            PlatformAdmin pa = installer.getPlatformAdmin();
            State systemState = pa.getState(false);
            PlatformAdminBundleTests.assertNotNull((Object)systemState.getBundle(0L));
            Bundle nativeTestF = installer.installBundle("nativetest.f");
            nativeTestF.start();
            errorCnt.await(5L, TimeUnit.SECONDS);
            PlatformAdminBundleTests.assertNull((String)("Found an error: " + error.get()), error.get());
        }
        finally {
            this.getContext().removeFrameworkListener(errorListener);
        }
    }

    public void testTimestamp() throws BundleException {
        PlatformAdmin pa = installer.getPlatformAdmin();
        State systemState = pa.getState(false);
        long initialTimeStamp = systemState.getTimeStamp();
        Bundle test = installer.installBundle("test");
        PlatformAdminBundleTests.assertTrue((String)"Timestamp has not changed.", (initialTimeStamp != systemState.getTimeStamp() ? 1 : 0) != 0);
        initialTimeStamp = systemState.getTimeStamp();
        ((BundleStartLevel)test.adapt(BundleStartLevel.class)).setStartLevel(1000);
        PlatformAdminBundleTests.assertTrue((String)"Timestamp has not changed.", (initialTimeStamp == systemState.getTimeStamp() ? 1 : 0) != 0);
        initialTimeStamp = systemState.getTimeStamp();
        test.uninstall();
        PlatformAdminBundleTests.assertTrue((String)"Timestamp has not changed.", (initialTimeStamp != systemState.getTimeStamp() ? 1 : 0) != 0);
    }
}

