/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.configuration;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.Test;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.FileSystemComparator;
import org.eclipse.core.tests.session.ConfigurationSessionTestSuite;
import org.eclipse.osgi.tests.OSGiTest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ReadOnlyConfigurationAreaTest
extends OSGiTest {
    public static Test suite() {
        ConfigurationSessionTestSuite suite = new ConfigurationSessionTestSuite("org.eclipse.osgi.tests", ReadOnlyConfigurationAreaTest.class);
        suite.setReadOnly(true);
        String[] ids = ConfigurationSessionTestSuite.MINIMAL_BUNDLE_SET;
        int i = 0;
        while (i < ids.length) {
            suite.addBundle(ids[i]);
            ++i;
        }
        suite.addBundle("org.eclipse.osgi.tests");
        return suite;
    }

    public ReadOnlyConfigurationAreaTest(String name) {
        super(name);
    }

    public void test0thSession() throws MalformedURLException, IOException {
        try {
            Bundle installed = BundleTestingHelper.installBundle((String)"1.0", (BundleContext)this.getContext(), (String)"test_files/configuration/bundle01");
            if (!BundleTestingHelper.resolveBundles((BundleContext)this.getContext(), (Bundle[])new Bundle[]{installed})) {
                ReadOnlyConfigurationAreaTest.fail((String)"1.1");
            }
        }
        catch (BundleException be) {
            ReadOnlyConfigurationAreaTest.fail((String)"1.2", (Throwable)be);
        }
    }

    public void test1stSession() {
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        FileSystemComparator comparator = new FileSystemComparator();
        Object snapshot = comparator.takeSnapshot(configurationDir, true);
        try {
            comparator.saveSnapshot(snapshot, configurationDir);
        }
        catch (IOException iOException) {
            ReadOnlyConfigurationAreaTest.fail((String)"1.0");
        }
    }

    public void test1stSessionFollowUp() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }

    public void test2ndSession() throws BundleException, IOException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)this.getContext(), (String)"test_files/configuration/bundle02");
                ReadOnlyConfigurationAreaTest.fail((String)"1.0");
            }
            catch (BundleException bundleException) {
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void test2ndSessionFollowUp() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }

    public void test3rdSession() throws BundleException, IOException {
        Bundle installed = null;
        try {
            try {
                installed = BundleTestingHelper.installBundle((BundleContext)this.getContext(), (String)"test_files/configuration/bundle03");
                ReadOnlyConfigurationAreaTest.fail((String)"1.0");
            }
            catch (BundleException bundleException) {
                if (installed != null) {
                    installed.uninstall();
                }
            }
        }
        finally {
            if (installed != null) {
                installed.uninstall();
            }
        }
    }

    public void test3rdSessionFollowUp() throws IOException {
        FileSystemComparator comparator = new FileSystemComparator();
        File configurationDir = ConfigurationSessionTestSuite.getConfigurationDir();
        Object oldSnaphot = comparator.loadSnapshot(configurationDir);
        Object newSnapshot = comparator.takeSnapshot(configurationDir, true);
        comparator.compareSnapshots("1.0", oldSnaphot, newSnapshot);
    }
}

