/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.eclipseadaptor;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;

public class EnvironmentInfoTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(EnvironmentInfoTest.class);
    }

    public EnvironmentInfoTest(String name) {
        super(name);
    }

    public void testAIX() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"aix", (String)EquinoxConfiguration.guessOS((String)"AIX"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"aix", (String)EquinoxConfiguration.guessOS((String)"aix"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"aix xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"motif", (String)EquinoxConfiguration.guessWS((String)"aix"));
    }

    public void testHPUX() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"hpux", (String)EquinoxConfiguration.guessOS((String)"HP-UX"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"hpux", (String)EquinoxConfiguration.guessOS((String)"hp-ux"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"hp-ux xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"motif", (String)EquinoxConfiguration.guessWS((String)"hpux"));
    }

    public void testLinux() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"linux", (String)EquinoxConfiguration.guessOS((String)"Linux"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"linux", (String)EquinoxConfiguration.guessOS((String)"linux"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"linux xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"gtk", (String)EquinoxConfiguration.guessWS((String)"linux"));
    }

    public void testMacOSX() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"macosx", (String)EquinoxConfiguration.guessOS((String)"Mac OS"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"macosx", (String)EquinoxConfiguration.guessOS((String)"Mac OS X"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"macosx", (String)EquinoxConfiguration.guessOS((String)"mac os x"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"cocoa", (String)EquinoxConfiguration.guessWS((String)"macosx"));
    }

    public void testQNX() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"qnx", (String)EquinoxConfiguration.guessOS((String)"QNX"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"qnx", (String)EquinoxConfiguration.guessOS((String)"qnx"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"qnx xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"photon", (String)EquinoxConfiguration.guessWS((String)"qnx"));
    }

    public void testSolaris() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"Solaris"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"solaris"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"solaris", (String)EquinoxConfiguration.guessOS((String)"SunOS"));
        EnvironmentInfoTest.assertEquals((String)"1.3", (String)"solaris", (String)EquinoxConfiguration.guessOS((String)"sunos"));
        EnvironmentInfoTest.assertEquals((String)"1.4", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"solaris xyz"));
        EnvironmentInfoTest.assertEquals((String)"1.4", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"sunos xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"gtk", (String)EquinoxConfiguration.guessWS((String)"solaris"));
    }

    public void testWindows() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"win32", (String)EquinoxConfiguration.guessOS((String)"Windows XP"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"win32", (String)EquinoxConfiguration.guessOS((String)"Windows 98"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"win32", (String)EquinoxConfiguration.guessOS((String)"Windows 2000"));
        EnvironmentInfoTest.assertEquals((String)"1.3", (String)"win32", (String)EquinoxConfiguration.guessOS((String)"Windows NT"));
        EnvironmentInfoTest.assertEquals((String)"1.4", (String)"win32", (String)EquinoxConfiguration.guessOS((String)"Windows 95"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"win32", (String)EquinoxConfiguration.guessWS((String)"win32"));
    }

    public void testISeries() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"os/400", (String)EquinoxConfiguration.guessOS((String)"OS/400"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"os/400", (String)EquinoxConfiguration.guessOS((String)"os/400"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"OS/400 xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"unknown", (String)EquinoxConfiguration.guessWS((String)"os/400"));
    }

    public void testZSeries() {
        EnvironmentInfoTest.assertEquals((String)"1.0", (String)"os/390", (String)EquinoxConfiguration.guessOS((String)"OS/390"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"os/390", (String)EquinoxConfiguration.guessOS((String)"os/390"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"z/os", (String)EquinoxConfiguration.guessOS((String)"z/os"));
        EnvironmentInfoTest.assertEquals((String)"1.1", (String)"z/os", (String)EquinoxConfiguration.guessOS((String)"Z/OS"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"OS/400 xyz"));
        EnvironmentInfoTest.assertEquals((String)"1.2", (String)"unknown", (String)EquinoxConfiguration.guessOS((String)"z/os xyz"));
        EnvironmentInfoTest.assertEquals((String)"2.0", (String)"unknown", (String)EquinoxConfiguration.guessWS((String)"os/390"));
    }
}

