/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.eventmgr;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;

public class EventManagerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(EventManagerTests.class);
    }

    public void testCopyOnWriteIdentityMap() {
        Object l1 = new Object();
        Object l2 = new Object();
        Object l3 = new Object();
        Object l4 = new Object();
        Object c1 = new Object();
        Object c2 = new Object();
        Object c3 = new Object();
        Object c4 = new Object();
        CopyOnWriteIdentityMap el1 = new CopyOnWriteIdentityMap();
        EventManagerTests.assertTrue((String)"not empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)el1.size());
        EventManagerTests.assertNull((String)"non null", (Object)el1.put(l1, c1));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)1, (int)el1.size());
        EventManagerTests.assertNull((String)"non null", (Object)el1.put(l2, c2));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)el1.size());
        EventManagerTests.assertNull((String)"non null", (Object)el1.put(l3, c3));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)3, (int)el1.size());
        EventManagerTests.assertNull((String)"non null", (Object)el1.put(l4, c4));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)el1.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el1.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el1.get(l4));
        CopyOnWriteIdentityMap el2 = new CopyOnWriteIdentityMap(el1);
        EventManagerTests.assertFalse((String)"empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)el2.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el1.remove(l2));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)3, (int)el1.size());
        EventManagerTests.assertEquals((String)"not null", null, (Object)el1.remove(l2));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)3, (int)el1.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el1.remove(l4));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)el1.size());
        EventManagerTests.assertEquals((String)"not null", null, (Object)el1.remove(l4));
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)el1.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        EventManagerTests.assertFalse((String)"empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)el2.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el2.remove(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el2.remove(l3));
        el1.putAll((Map)el2);
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)el1.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el1.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el1.get(l4));
        EventManagerTests.assertFalse((String)"empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)el2.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        el2.putAll((Map)el1);
        EventManagerTests.assertFalse((String)"empty", (boolean)el1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)el1.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el1.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el1.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el1.get(l3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el1.get(l4));
        EventManagerTests.assertFalse((String)"empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)el2.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, (Object)el2.get(l2));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        el2.clear();
        EventManagerTests.assertTrue((String)"not empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)el2.size());
        EventManagerTests.assertNull((String)"non null", (Object)el2.put(l1, c1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el2.put(l1, c3));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, (Object)el2.get(l1));
        EventManagerTests.assertTrue((String)"missed key", (boolean)el2.containsKey(l1));
        EventManagerTests.assertTrue((String)"missed value", (boolean)el2.containsValue(c3));
        EventManagerTests.assertFalse((String)"invalid key", (boolean)el2.containsKey(l2));
        EventManagerTests.assertFalse((String)"invalid value", (boolean)el2.containsValue(c1));
        el2.clear();
        HashMap<Object, Object> source = new HashMap<Object, Object>();
        source.put(l1, c1);
        source.put(l4, c4);
        el2.putAll(source);
        EventManagerTests.assertFalse((String)"empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)el2.size());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, (Object)el2.get(l1));
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, (Object)el2.get(l4));
        el2.clear();
        Set k1 = el1.keySet();
        Set k2 = el2.keySet();
        Set k3 = el1.keySet();
        Set k4 = el1.keySet();
        Collection v1 = el1.values();
        Collection v2 = el2.values();
        Collection v3 = el1.values();
        Collection v4 = el1.values();
        Set e1 = el1.entrySet();
        Set e2 = el2.entrySet();
        Set e3 = el1.entrySet();
        Set e4 = el1.entrySet();
        Set e5 = el1.entrySet();
        el1.clear();
        EventManagerTests.assertFalse((String)"empty", (boolean)k1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)k1.size());
        EventManagerTests.assertTrue((String)"missed key", (boolean)k1.contains(l1));
        EventManagerTests.assertTrue((String)"missed key", (boolean)k1.contains(l2));
        EventManagerTests.assertTrue((String)"missed key", (boolean)k1.contains(l3));
        EventManagerTests.assertTrue((String)"missed key", (boolean)k1.contains(l4));
        EventManagerTests.assertTrue((String)"missed key", (boolean)k1.containsAll(Arrays.asList(l1, l2, l3, l4)));
        EventManagerTests.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{l1, l3, l2, l4}, k1.toArray()));
        EventManagerTests.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{l1, l3, l2, l4}, k1.toArray(new Object[4])));
        Iterator i1 = k1.iterator();
        EventManagerTests.assertTrue((String)"missing next", (boolean)i1.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)l1, i1.next());
        i1.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)3, (int)k1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)k1.contains(l1));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i1.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)l3, i1.next());
        i1.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)k1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)k1.contains(l3));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i1.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)l2, i1.next());
        i1.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)1, (int)k1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)k1.contains(l2));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i1.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)l4, i1.next());
        i1.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)k1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)k1.contains(l4));
        EventManagerTests.assertFalse((String)"extra next", (boolean)i1.hasNext());
        try {
            i1.next();
            EventManagerTests.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        EventManagerTests.assertTrue((String)"not empty", (boolean)k2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)k2.size());
        Iterator i2 = k2.iterator();
        EventManagerTests.assertFalse((String)"extra next", (boolean)i2.hasNext());
        try {
            i2.next();
            EventManagerTests.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            k2.add(l1);
            EventManagerTests.fail((String)"add did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            k2.addAll(Arrays.asList(l1, l2));
            EventManagerTests.fail((String)"addAll did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        k3.remove(l3);
        EventManagerTests.assertFalse((String)"not removed", (boolean)k3.contains(l3));
        k3.removeAll(Arrays.asList(l1, l2));
        EventManagerTests.assertFalse((String)"not removed", (boolean)k3.contains(l1));
        EventManagerTests.assertFalse((String)"not removed", (boolean)k3.contains(l2));
        k4.retainAll(Arrays.asList(l1, l2));
        EventManagerTests.assertTrue((String)"missing", (boolean)k4.contains(l1));
        EventManagerTests.assertTrue((String)"missing", (boolean)k4.contains(l2));
        EventManagerTests.assertFalse((String)"not removed", (boolean)k4.contains(l3));
        EventManagerTests.assertFalse((String)"not removed", (boolean)k4.contains(l4));
        k4.clear();
        EventManagerTests.assertTrue((String)"not empty", (boolean)k4.isEmpty());
        EventManagerTests.assertFalse((String)"empty", (boolean)v1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)v1.size());
        EventManagerTests.assertTrue((String)"missed key", (boolean)v1.contains(c1));
        EventManagerTests.assertTrue((String)"missed key", (boolean)v1.contains(c2));
        EventManagerTests.assertTrue((String)"missed key", (boolean)v1.contains(c3));
        EventManagerTests.assertTrue((String)"missed key", (boolean)v1.contains(c4));
        EventManagerTests.assertTrue((String)"missed key", (boolean)v1.containsAll(Arrays.asList(c1, c2, c3, c4)));
        EventManagerTests.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{c1, c3, c2, c4}, v1.toArray()));
        EventManagerTests.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Object[]{c1, c3, c2, c4}, v1.toArray(new Object[4])));
        Iterator i3 = v1.iterator();
        EventManagerTests.assertTrue((String)"missing next", (boolean)i3.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)c1, i3.next());
        i3.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)3, (int)v1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)v1.contains(c1));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i3.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)c3, i3.next());
        i3.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)v1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)v1.contains(c3));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i3.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)c2, i3.next());
        i3.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)1, (int)v1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)v1.contains(c2));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i3.hasNext());
        EventManagerTests.assertEquals((String)"wrong key", (Object)c4, i3.next());
        i3.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)v1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)v1.contains(c4));
        EventManagerTests.assertFalse((String)"extra next", (boolean)i3.hasNext());
        try {
            i3.next();
            EventManagerTests.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        EventManagerTests.assertTrue((String)"not empty", (boolean)v2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)v2.size());
        Iterator i4 = v2.iterator();
        EventManagerTests.assertFalse((String)"extra next", (boolean)i4.hasNext());
        try {
            i4.next();
            EventManagerTests.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            v2.add(c1);
            EventManagerTests.fail((String)"add did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            v2.addAll(Arrays.asList(c1, c2));
            EventManagerTests.fail((String)"addAll did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        v3.remove(c3);
        EventManagerTests.assertFalse((String)"not removed", (boolean)v3.contains(c3));
        v3.removeAll(Arrays.asList(c1, c2));
        EventManagerTests.assertFalse((String)"not removed", (boolean)v3.contains(c1));
        EventManagerTests.assertFalse((String)"not removed", (boolean)v3.contains(c2));
        v4.retainAll(Arrays.asList(c1, c2));
        EventManagerTests.assertTrue((String)"missing", (boolean)v4.contains(c1));
        EventManagerTests.assertTrue((String)"missing", (boolean)v4.contains(c2));
        EventManagerTests.assertFalse((String)"not removed", (boolean)v4.contains(c3));
        EventManagerTests.assertFalse((String)"not removed", (boolean)v4.contains(c4));
        v4.clear();
        EventManagerTests.assertTrue((String)"not empty", (boolean)v4.isEmpty());
        EventManagerTests.assertFalse((String)"empty", (boolean)e1.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)4, (int)e1.size());
        Iterator i5 = e1.iterator();
        EventManagerTests.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me1 = (Map.Entry)i5.next();
        EventManagerTests.assertEquals((String)"wrong key", (Object)l1, me1.getKey());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c1, me1.getValue());
        try {
            me1.setValue(c2);
            EventManagerTests.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        i5.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)3, (int)e1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)e1.contains(me1));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me3 = (Map.Entry)i5.next();
        EventManagerTests.assertEquals((String)"wrong key", (Object)l3, me3.getKey());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c3, me3.getValue());
        try {
            me3.setValue(c2);
            EventManagerTests.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        i5.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)e1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)e1.contains(me3));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me2 = (Map.Entry)i5.next();
        EventManagerTests.assertEquals((String)"wrong key", (Object)l2, me2.getKey());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c2, me2.getValue());
        try {
            me2.setValue(c3);
            EventManagerTests.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        i5.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)1, (int)e1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)e1.contains(me2));
        EventManagerTests.assertTrue((String)"missing next", (boolean)i5.hasNext());
        Map.Entry me4 = (Map.Entry)i5.next();
        EventManagerTests.assertEquals((String)"wrong key", (Object)l4, me4.getKey());
        EventManagerTests.assertEquals((String)"wrong value", (Object)c4, me4.getValue());
        try {
            me4.setValue(c2);
            EventManagerTests.fail((String)"remove did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        i5.remove();
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)e1.size());
        EventManagerTests.assertFalse((String)"still present", (boolean)e1.contains(me4));
        EventManagerTests.assertFalse((String)"extra next", (boolean)i5.hasNext());
        try {
            i1.next();
            EventManagerTests.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        EventManagerTests.assertTrue((String)"not empty", (boolean)e2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)0, (int)e2.size());
        Iterator i6 = e2.iterator();
        EventManagerTests.assertFalse((String)"extra next", (boolean)i6.hasNext());
        try {
            i6.next();
            EventManagerTests.fail((String)"next did not throw exception");
        }
        catch (NoSuchElementException noSuchElementException) {}
        try {
            e2.add(me1);
            EventManagerTests.fail((String)"add did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            e2.addAll(Arrays.asList(me2, me4));
            EventManagerTests.fail((String)"addAll did not throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        e3.remove(me3);
        EventManagerTests.assertFalse((String)"not removed", (boolean)e3.contains(me3));
        e3.removeAll(Arrays.asList(me1, me2));
        EventManagerTests.assertFalse((String)"not removed", (boolean)e3.contains(me1));
        EventManagerTests.assertFalse((String)"not removed", (boolean)e3.contains(me2));
        e4.retainAll(Arrays.asList(me1, me2));
        EventManagerTests.assertTrue((String)"missing", (boolean)e4.contains(me1));
        EventManagerTests.assertTrue((String)"missing", (boolean)e4.contains(me2));
        EventManagerTests.assertFalse((String)"not removed", (boolean)e4.contains(me3));
        EventManagerTests.assertFalse((String)"not removed", (boolean)e4.contains(me4));
        e4.clear();
        EventManagerTests.assertTrue((String)"not empty", (boolean)e4.isEmpty());
        EventManagerTests.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Map.Entry[]{me1, me3, me2, me4}, e5.toArray()));
        EventManagerTests.assertTrue((String)"array unequal", (boolean)Arrays.equals(new Map.Entry[]{me1, me3, me2, me4}, e5.toArray(new Map.Entry[4])));
        el2.clear();
        el2.putAll(new Object[]{l1, l3});
        EventManagerTests.assertFalse((String)"empty", (boolean)el2.isEmpty());
        EventManagerTests.assertEquals((String)"wrong size", (int)2, (int)el2.size());
        EventManagerTests.assertTrue((String)"missed key", (boolean)el2.containsKey(l1));
        EventManagerTests.assertTrue((String)"missed key", (boolean)el2.containsKey(l3));
        EventManagerTests.assertNull((String)"value not null", (Object)el2.get(l1));
        EventManagerTests.assertNull((String)"value not null", (Object)el2.get(l3));
    }
}

