/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.filter.BundleContextFilterTests;
import org.eclipse.osgi.tests.filter.FrameworkUtilFilterTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public abstract class FilterTests
extends TestCase {
    static final int ISTRUE = 1;
    static final int ISFALSE = 2;
    static final int ISILLEGAL = 3;

    public static Test suite() {
        TestSuite suite = new TestSuite(FilterTests.class.getName());
        suite.addTest(BundleContextFilterTests.suite());
        suite.addTest(FrameworkUtilFilterTests.suite());
        return suite;
    }

    public static void fail(String message, Throwable t) {
        AssertionFailedError e = new AssertionFailedError(String.valueOf(message) + ": " + t.getMessage());
        e.initCause(t);
        throw e;
    }

    public abstract Filter createFilter(String var1) throws InvalidSyntaxException;

    private Dictionary getProperties() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("room", "bedroom");
        ((Dictionary)props).put("channel", new Object[]{new Integer(34), "101"});
        ((Dictionary)props).put("status", "(on\\)*");
        ArrayList<Object> vec = new ArrayList<Object>(10);
        vec.add(new Long(150L));
        vec.add("100");
        ((Dictionary)props).put("max record time", vec);
        ((Dictionary)props).put("canrecord", "true(x)");
        ((Dictionary)props).put("shortvalue", new Short(1000));
        ((Dictionary)props).put("intvalue", new Integer(100000));
        ((Dictionary)props).put("longvalue", new Long(10000000000L));
        ((Dictionary)props).put("bytevalue", new Byte(10));
        ((Dictionary)props).put("floatvalue", new Float(1.01));
        ((Dictionary)props).put("doublevalue", new Double(2.01));
        ((Dictionary)props).put("charvalue", new Character('A'));
        ((Dictionary)props).put("booleanvalue", Boolean.TRUE);
        ((Dictionary)props).put("weirdvalue", new Hashtable());
        ((Dictionary)props).put("primintarrayvalue", new int[]{1, 2, 3});
        ((Dictionary)props).put("primlongarrayvalue", new long[]{1L, 2L, 3L});
        ((Dictionary)props).put("primbytearrayvalue", new byte[]{1, 2, 3});
        ((Dictionary)props).put("primshortarrayvalue", new short[]{1, 2, 3});
        ((Dictionary)props).put("primfloatarrayvalue", new float[]{1.1f, 2.2f, 3.3f});
        ((Dictionary)props).put("primdoublearrayvalue", new double[]{1.1, 2.2, 3.3});
        ((Dictionary)props).put("primchararrayvalue", new char[]{'A', 'b', 'C', 'd'});
        ((Dictionary)props).put("primbooleanarrayvalue", new boolean[1]);
        ((Dictionary)props).put("bigintvalue", new BigInteger("4123456"));
        ((Dictionary)props).put("bigdecvalue", new BigDecimal("4.123456"));
        ((Dictionary)props).put("*", "foo");
        ((Dictionary)props).put("!  ab", "b");
        ((Dictionary)props).put("|   ab", "b");
        ((Dictionary)props).put("&    ab", "b");
        ((Dictionary)props).put("!", "c");
        ((Dictionary)props).put("|", "c");
        ((Dictionary)props).put("&", "c");
        ((Dictionary)props).put("empty", "");
        ((Dictionary)props).put("space", new Character(' '));
        return props;
    }

    public void testFilter() {
        Dictionary props = this.getProperties();
        this.testFilter("(room=*)", props, 1);
        this.testFilter("(room=bedroom)", props, 1);
        this.testFilter("(room~= B E D R O O M )", props, 1);
        this.testFilter("(room=abc)", props, 2);
        this.testFilter(" ( room >=aaaa)", props, 1);
        this.testFilter("(room <=aaaa)", props, 2);
        this.testFilter("  ( room =b*) ", props, 1);
        this.testFilter("  ( room =*m) ", props, 1);
        this.testFilter("(room=bed*room)", props, 1);
        this.testFilter("  ( room =b*oo*m) ", props, 1);
        this.testFilter("  ( room =*b*oo*m*) ", props, 1);
        this.testFilter("  ( room =b*b*  *m*) ", props, 2);
        this.testFilter("  (& (room =bedroom) (channel ~=34))", props, 1);
        this.testFilter("  (&  (room =b*)  (room =*x) (channel=34))", props, 2);
        this.testFilter("(| (room =bed*)(channel=222)) ", props, 1);
        this.testFilter("(| (room =boom*)(channel=101)) ", props, 1);
        this.testFilter("  (! (room =ab*b*oo*m*) ) ", props, 1);
        this.testFilter("  (status =\\(o*\\\\\\)\\*) ", props, 1);
        this.testFilter("  (canRecord =true\\(x\\)) ", props, 1);
        this.testFilter("(max Record Time <=140) ", props, 1);
        this.testFilter("(shortValue >=100) ", props, 1);
        this.testFilter("(intValue <=100001) ", props, 1);
        this.testFilter("(longValue >=10000000000) ", props, 1);
        this.testFilter("  (  &  (  byteValue <=100)  (  byteValue >=10)  )  ", props, 1);
        this.testFilter("(weirdValue =100) ", props, 2);
        this.testFilter("(bigIntValue =4123456) ", props, 1);
        this.testFilter("(bigDecValue =4.123456) ", props, 1);
        this.testFilter("(floatValue >=1.0) ", props, 1);
        this.testFilter("(doubleValue <=2.011) ", props, 1);
        this.testFilter("(charValue ~=a) ", props, 1);
        this.testFilter("(booleanValue =true) ", props, 1);
        this.testFilter("(primIntArrayValue =1) ", props, 1);
        this.testFilter("(primLongArrayValue =2) ", props, 1);
        this.testFilter("(primByteArrayValue =3) ", props, 1);
        this.testFilter("(primShortArrayValue =1) ", props, 1);
        this.testFilter("(primFloatArrayValue =1.1) ", props, 1);
        this.testFilter("(primDoubleArrayValue =2.2) ", props, 1);
        this.testFilter("(primCharArrayValue ~=D) ", props, 1);
        this.testFilter("(primBooleanArrayValue =false) ", props, 1);
        this.testFilter("(& (| (room =d*m) (room =bed*) (room=abc)) (! (channel=999)))", props, 1);
        this.testFilter("(room=bedroom)", null, 2);
        this.testFilter("(*=foo)", props, 1);
        this.testFilter("(!  ab=b)", props, 1);
        this.testFilter("(|   ab=b)", props, 1);
        this.testFilter("(&=c)", props, 1);
        this.testFilter("(!=c)", props, 1);
        this.testFilter("(|=c)", props, 1);
        this.testFilter("(&    ab=b)", props, 1);
        this.testFilter("(!ab=*)", props, 2);
        this.testFilter("(|ab=*)", props, 2);
        this.testFilter("(&ab=*)", props, 2);
        this.testFilter("(empty=)", props, 1);
        this.testFilter("(empty=*)", props, 1);
        this.testFilter("(space= )", props, 1);
        this.testFilter("(space=*)", props, 1);
    }

    public void testInvalidValues() {
        Dictionary props = this.getProperties();
        this.testFilter("(intvalue=*)", props, 1);
        this.testFilter("(intvalue=b)", props, 2);
        this.testFilter("(intvalue=)", props, 2);
        this.testFilter("(longvalue=*)", props, 1);
        this.testFilter("(longvalue=b)", props, 2);
        this.testFilter("(longvalue=)", props, 2);
        this.testFilter("(shortvalue=*)", props, 1);
        this.testFilter("(shortvalue=b)", props, 2);
        this.testFilter("(shortvalue=)", props, 2);
        this.testFilter("(bytevalue=*)", props, 1);
        this.testFilter("(bytevalue=b)", props, 2);
        this.testFilter("(bytevalue=)", props, 2);
        this.testFilter("(charvalue=*)", props, 1);
        this.testFilter("(charvalue=)", props, 2);
        this.testFilter("(floatvalue=*)", props, 1);
        this.testFilter("(floatvalue=b)", props, 2);
        this.testFilter("(floatvalue=)", props, 2);
        this.testFilter("(doublevalue=*)", props, 1);
        this.testFilter("(doublevalue=b)", props, 2);
        this.testFilter("(doublevalue=)", props, 2);
        this.testFilter("(booleanvalue=*)", props, 1);
        this.testFilter("(booleanvalue=b)", props, 2);
        this.testFilter("(booleanvalue=)", props, 2);
    }

    public void testIllegal() {
        Dictionary props = this.getProperties();
        this.testFilter("", props, 3);
        this.testFilter("()", props, 3);
        this.testFilter("(=foo)", props, 3);
        this.testFilter("(", props, 3);
        this.testFilter("(abc = ))", props, 3);
        this.testFilter("(& (abc = xyz) (& (345))", props, 3);
        this.testFilter("  (room = b**oo!*m*) ) ", props, 3);
        this.testFilter("  (room = b**oo)*m*) ) ", props, 3);
        this.testFilter("  (room = *=b**oo*m*) ) ", props, 3);
        this.testFilter("  (room = =b**oo*m*) ) ", props, 3);
    }

    public void testScalarSubstring() {
        Dictionary props = this.getProperties();
        this.testFilter("(shortValue =100*) ", props, 2);
        this.testFilter("(intValue =100*) ", props, 2);
        this.testFilter("(longValue =100*) ", props, 2);
        this.testFilter("(  byteValue =1*00  )", props, 2);
        this.testFilter("(bigIntValue =4*23456) ", props, 2);
        this.testFilter("(bigDecValue =4*123456) ", props, 2);
        this.testFilter("(floatValue =1*0) ", props, 2);
        this.testFilter("(doubleValue =2*011) ", props, 2);
        this.testFilter("(charValue =a*) ", props, 2);
        this.testFilter("(booleanValue =t*ue) ", props, 2);
    }

    public void testNormalization() {
        try {
            Filter f1 = this.createFilter("( a = bedroom  )");
            Filter f2 = this.createFilter(" (a= bedroom  ) ");
            FilterTests.assertEquals((String)"not equal", (String)"(a= bedroom  )", (String)f1.toString());
            FilterTests.assertEquals((String)"not equal", (String)"(a= bedroom  )", (String)f2.toString());
            FilterTests.assertEquals((String)"not equal", (Object)f1, (Object)f2);
            FilterTests.assertEquals((String)"not equal", (Object)f2, (Object)f1);
            FilterTests.assertEquals((String)"not equal", (int)f1.hashCode(), (int)f2.hashCode());
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("unexpected invalid syntax", e);
        }
    }

    private void testFilter(String query, Dictionary props, int expect) {
        Filter f2;
        Filter f1;
        DictionaryServiceReference ref = new DictionaryServiceReference(props);
        try {
            f1 = this.createFilter(query);
            if (expect == 3) {
                FilterTests.fail((String)"expected exception");
            }
        }
        catch (InvalidSyntaxException e) {
            if (expect != 3) {
                FilterTests.fail("exception", e);
            }
            return;
        }
        boolean val = f1.match(props);
        FilterTests.assertEquals((String)"wrong result", (expect == 1 ? 1 : 0) != 0, (boolean)val);
        val = f1.match((ServiceReference)ref);
        FilterTests.assertEquals((String)"wrong result", (expect == 1 ? 1 : 0) != 0, (boolean)val);
        String normalized = f1.toString();
        try {
            f2 = this.createFilter(normalized);
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("exception", e);
            return;
        }
        val = f2.match(props);
        FilterTests.assertEquals((String)"wrong result", (expect == 1 ? 1 : 0) != 0, (boolean)val);
        val = f2.match((ServiceReference)ref);
        FilterTests.assertEquals((String)"wrong result", (expect == 1 ? 1 : 0) != 0, (boolean)val);
        FilterTests.assertEquals((String)"normalized not equal", (String)normalized, (String)f2.toString());
    }

    public void testComparable() {
        Filter f1 = null;
        SampleComparable comp42 = new SampleComparable("42");
        SampleComparable comp43 = new SampleComparable("43");
        Hashtable<String, SampleComparable> hash = new Hashtable<String, SampleComparable>();
        try {
            f1 = this.createFilter("(comparable=42)");
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("invalid syntax", e);
        }
        hash.put("comparable", comp42);
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        hash.put("comparable", comp43);
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        try {
            f1 = this.createFilter("(comparable<=42)");
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("invalid syntax", e);
        }
        hash.put("comparable", comp42);
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        hash.put("comparable", comp43);
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        try {
            f1 = this.createFilter("(comparable>=42)");
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("invalid syntax", e);
        }
        hash.put("comparable", comp42);
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        hash.put("comparable", comp43);
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        try {
            f1 = this.createFilter("(comparable=4*2)");
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("invalid syntax", e);
        }
        hash.put("comparable", comp42);
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
    }

    public void testObject() {
        Filter f1 = null;
        SampleObject obj42 = new SampleObject("42");
        SampleObject obj43 = new SampleObject("43");
        Hashtable<String, SampleObject> hash = new Hashtable<String, SampleObject>();
        try {
            f1 = this.createFilter("(object=42)");
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("invalid syntax", e);
        }
        hash.put("object", obj42);
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match(hash));
        FilterTests.assertTrue((String)"does not match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        hash.put("object", obj43);
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
        try {
            f1 = this.createFilter("(object=4*2)");
        }
        catch (InvalidSyntaxException e) {
            FilterTests.fail("invalid syntax", e);
        }
        hash.put("object", obj42);
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match(hash));
        FilterTests.assertFalse((String)"does match filter", (boolean)f1.match((ServiceReference)new DictionaryServiceReference(hash)));
    }

    private static class DictionaryServiceReference
    implements ServiceReference {
        private final Dictionary dictionary;
        private final String[] keys;

        DictionaryServiceReference(Dictionary dictionary) {
            if (dictionary == null) {
                this.dictionary = null;
                this.keys = new String[0];
                return;
            }
            this.dictionary = dictionary;
            ArrayList<String> keyList = new ArrayList<String>(dictionary.size());
            Enumeration e = dictionary.keys();
            while (e.hasMoreElements()) {
                Object k = e.nextElement();
                if (!(k instanceof String)) continue;
                String key = (String)k;
                Iterator i = keyList.iterator();
                while (i.hasNext()) {
                    if (!key.equalsIgnoreCase((String)i.next())) continue;
                    throw new IllegalArgumentException();
                }
                keyList.add(key);
            }
            this.keys = keyList.toArray(new String[keyList.size()]);
        }

        public Object getProperty(String k) {
            int i = 0;
            int length = this.keys.length;
            while (i < length) {
                String key = this.keys[i];
                if (key.equalsIgnoreCase(k)) {
                    return this.dictionary.get(key);
                }
                ++i;
            }
            return null;
        }

        public String[] getPropertyKeys() {
            return (String[])this.keys.clone();
        }

        public int compareTo(Object reference) {
            throw new UnsupportedOperationException();
        }

        public Bundle getBundle() {
            throw new UnsupportedOperationException();
        }

        public Bundle[] getUsingBundles() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableTo(Bundle bundle, String className) {
            throw new UnsupportedOperationException();
        }
    }

    public static class SampleComparable
    implements Comparable {
        private int value = -1;

        public SampleComparable(String value) {
            this.value = Integer.parseInt(value);
        }

        public int compareTo(Object o) {
            return this.value - ((SampleComparable)o).value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static class SampleObject {
        private int value = -1;

        public SampleObject(String value) {
            this.value = Integer.parseInt(value);
        }

        public boolean equals(Object o) {
            if (o instanceof SampleObject) {
                return this.value == ((SampleObject)o).value;
            }
            return false;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

