/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.hooks.framework;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.hooks.framework.AbstractFrameworkHookTests;
import org.osgi.framework.Bundle;
import org.osgi.framework.launch.Framework;

public class BundleFileWrapperFactoryHookTests
extends AbstractFrameworkHookTests {
    private static final String TEST_BUNDLE = "substitutes.a";
    private static final String HOOK_CONFIGURATOR_BUNDLE = "wrapper.hooks.a";
    private static final String HOOK_CONFIGURATOR_CLASS = "org.eclipse.osgi.tests.wrapper.hooks.a.TestHookConfigurator";
    private Map<String, String> configuration;
    private Framework framework;
    private String location;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        String loc = this.bundleInstaller.getBundleLocation(HOOK_CONFIGURATOR_BUNDLE);
        loc = loc.substring(loc.indexOf("file:"));
        this.classLoader.addURL(new URL(loc));
        this.location = this.bundleInstaller.getBundleLocation(TEST_BUNDLE);
        File file = OSGiTestsActivator.getContext().getDataFile(this.getName());
        this.configuration = new HashMap<String, String>();
        this.configuration.put("org.osgi.framework.storage", file.getAbsolutePath());
        this.configuration.put("osgi.hook.configurators.include", HOOK_CONFIGURATOR_CLASS);
        this.framework = this.createFramework(this.configuration);
    }

    @Override
    protected void tearDown() throws Exception {
        this.stopQuietly(this.framework);
        super.tearDown();
    }

    private void initAndStartFramework() throws Exception {
        this.initAndStart(this.framework);
    }

    private Bundle installBundle() throws Exception {
        return this.framework.getBundleContext().installBundle(this.location);
    }

    public void testGetResourceURL() throws Exception {
        this.initAndStartFramework();
        Bundle b = this.installBundle();
        URL url1 = b.getResource("data/resource1");
        BundleFileWrapperFactoryHookTests.assertEquals((String)("Wrong protocol used: " + url1), (String)"custom", (String)url1.getProtocol());
        BundleFileWrapperFactoryHookTests.assertEquals((String)"Wrong content found.", (String)"CUSTOM_CONTENT", (String)this.readURL(url1));
    }

    private String readURL(URL url) {
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            try {
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line);
                    line = reader.readLine();
                    if (line == null) continue;
                    sb.append('\n');
                }
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            BundleFileWrapperFactoryHookTests.fail((String)("Unexpected exception reading url: " + url.toExternalForm()), (Throwable)e);
        }
        return sb.toString();
    }
}

