/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.perf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.perf.BasePerformanceTest;

public class StatePerformanceTest
extends BasePerformanceTest {
    private static final String DEGREDATION_STORE_RETRIEVE = "Performance decrease caused by additional fuctionality required for generic capabilities/requirements in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.";

    public static Test suite() {
        return new TestSuite(StatePerformanceTest.class);
    }

    public StatePerformanceTest(String name) {
        super(name);
    }

    State storeAndRetrieve(State toStore) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        toStore.getFactory().writeState(toStore, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return toStore.getFactory().readState((InputStream)bais);
    }

    public void testCreation() {
        new PerformanceTestRunner(){

            protected void test() {
                StatePerformanceTest.this.buildRandomState(5000);
            }
        }.run((TestCase)this, 10, 10);
    }

    private void testResolution(int stateSize, int repetitions, String localName, String degradation) {
        final State originalState = this.buildRandomState(stateSize);
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                originalState.resolve(false);
            }
        };
        runner.setRegressionReason(degradation);
        runner.run((TestCase)this, localName, 10, repetitions);
    }

    public void testResolution100() {
        this.testResolution(100, 500, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    public void testResolution1000() {
        this.testResolution(1000, 15, "State Resolution", null);
    }

    public void testResolution500() {
        this.testResolution(500, 50, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    public void testResolution5000() {
        this.testResolution(5000, 1, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    public void testStoreAndRetrieve() {
        int stateSize = 5000;
        final State originalState = this.buildRandomState(stateSize);
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                try {
                    StatePerformanceTest.this.storeAndRetrieve(originalState);
                }
                catch (IOException e) {
                    CoreTest.fail((String)"", (Throwable)e);
                }
            }
        };
        runner.setRegressionReason(DEGREDATION_STORE_RETRIEVE);
        runner.run((TestCase)this, 10, 10);
    }
}

