/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.perf;

import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.tests.perf.BasePerformanceTest;
import org.osgi.framework.BundleException;

public class StateUsesPerformanceTest
extends BasePerformanceTest {
    public static Test suite() {
        return new TestSuite(StateUsesPerformanceTest.class);
    }

    public StateUsesPerformanceTest(String name) {
        super(name);
    }

    private void doUsesResolution(int stateSize, int repetitions, String localName, String degradation) throws BundleException {
        final State originalState = this.buildRandomState(stateSize);
        this.addUsesBundles(originalState);
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                originalState.resolve(false);
            }
        };
        runner.setRegressionReason(degradation);
        runner.run((TestCase)this, localName, 10, repetitions);
    }

    public void testUsesResolution00100() throws BundleException {
        this.doUsesResolution(100, 100, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    public void testUsesResolution00500() throws BundleException {
        this.doUsesResolution(500, 10, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    public void testUsesResolution01000() throws BundleException {
        this.doUsesResolution(1000, 10, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    public void testUsesResolution05000() throws BundleException {
        this.doUsesResolution(5000, 1, null, "Performance decrease caused by additional fuctionality required for ResovlerHooks in OSGi R4.3 specification. See https://bugs.eclipse.org/bugs/show_bug.cgi?id=324753 for details.");
    }

    private void addUsesBundles(State state) throws BundleException {
        int id = state.getBundles().length + 500;
        Hashtable<String, String> manifest = new Hashtable<String, String>();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "a");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put("Export-Package", "a");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "3.0.0");
        manifest.put("Export-Package", "a");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "4.0.0");
        manifest.put("Export-Package", "a");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "A");
        manifest.put("Bundle-Version", "5.0.0");
        manifest.put("Export-Package", "a");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0.0,2.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0.0,2.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "3.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0.0,2.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "4.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0.0,2.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "B");
        manifest.put("Bundle-Version", "5.0.0");
        manifest.put("Export-Package", "b; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[1.0.0,2.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "c; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[2.0.0,3.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "2.0.0");
        manifest.put("Export-Package", "c; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[2.0.0,3.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "3.0.0");
        manifest.put("Export-Package", "c; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[2.0.0,3.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "4.0.0");
        manifest.put("Export-Package", "c; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[2.0.0,3.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "C");
        manifest.put("Bundle-Version", "5.0.0");
        manifest.put("Export-Package", "c; uses:=a");
        manifest.put("Require-Bundle", "A; bundle-version=\"[2.0.0,3.0.0)\"; visibility:=reexport");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
        manifest = new Hashtable();
        manifest.put("Bundle-ManifestVersion", "2");
        manifest.put("Bundle-SymbolicName", "F");
        manifest.put("Bundle-Version", "1.0.0");
        manifest.put("Export-Package", "f; uses:=b");
        manifest.put("Require-Bundle", "A, B, C");
        state.addBundle(state.getFactory().createBundleDescription(state, manifest, String.valueOf((String)manifest.get("Bundle-SymbolicName")) + (String)manifest.get("Bundle-Version"), (long)id++));
    }
}

