/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.plugins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.osgi.service.pluginconversion.PluginConverter;
import org.eclipse.osgi.tests.OSGiTestsActivator;
import org.eclipse.osgi.tests.bundles.BundleInstaller;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class OldStylePluginTests
extends CoreTest {
    public static int BUNDLE_LISTENER = 1;
    public static int SYNC_BUNDLE_LISTENER = 2;
    public static int SIMPLE_RESULTS = 4;
    public static final String BUNDLES_ROOT = "bundle_tests";
    private BundleInstaller installer;
    private boolean compatPluginInstalled = false;

    public static Test suite() {
        return new TestSuite(OldStylePluginTests.class);
    }

    protected void setUp() throws Exception {
        this.compatPluginInstalled = false;
        for (BundleWire hostWire : ((BundleWiring)this.getContext().getBundle("System Bundle").adapt(BundleWiring.class)).getProvidedWires("osgi.wiring.host")) {
            if (!"org.eclipse.osgi.compatibility.plugins".equals(hostWire.getRequirer().getSymbolicName())) continue;
            this.compatPluginInstalled = true;
            break;
        }
        if (this.compatPluginInstalled) {
            OldStylePluginTests.assertTrue((String)"Plugin compatibility fragment not configured.", (this.getContext().getServiceReference(PluginConverter.class) != null ? 1 : 0) != 0);
        }
        this.installer = new BundleInstaller(BUNDLES_ROOT, OSGiTestsActivator.getContext());
        this.installer.refreshPackages(null);
    }

    protected void tearDown() throws Exception {
        this.installer.shutdown();
        this.installer = null;
    }

    public BundleContext getContext() {
        return OSGiTestsActivator.getContext();
    }

    public void testSimplePlugin() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.a";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, false);
        OldStylePluginTests.assertTrue((String)"Did not expect any requirements.", (boolean)revision.getDeclaredRequirements(null).isEmpty());
    }

    public void testImportPlugin() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.b";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, false);
        List requirements = revision.getDeclaredRequirements(null);
        OldStylePluginTests.assertEquals((String)("Wrong number of requirements: " + requirements), (int)7, (int)requirements.size());
        int index = 0;
        for (BundleRequirement req : requirements) {
            String visibility;
            HashMap<String, String> matchAttributes = new HashMap<String, String>();
            HashMap<String, String> noMatchAttributes = new HashMap<String, String>();
            matchAttributes.put("osgi.wiring.bundle", "x" + ++index);
            noMatchAttributes.put("osgi.wiring.bundle", "x" + index);
            Version match = null;
            Version noMatch = null;
            switch (index) {
                case 1: {
                    match = Version.parseVersion((String)"1.0.0");
                    noMatch = Version.parseVersion((String)"1.0.0.x");
                    break;
                }
                case 2: {
                    match = Version.parseVersion((String)"1.0.100");
                    noMatch = Version.parseVersion((String)"1.1");
                    break;
                }
                case 4: {
                    match = Version.parseVersion((String)"90000");
                    noMatch = Version.parseVersion((String)"0.1");
                    break;
                }
                default: {
                    match = Version.parseVersion((String)"1.1");
                    noMatch = Version.parseVersion((String)"2.0");
                }
            }
            matchAttributes.put("bundle-version", (String)match);
            noMatchAttributes.put("bundle-version", (String)noMatch);
            Filter f = null;
            try {
                f = this.getContext().createFilter((String)req.getDirectives().get("filter"));
            }
            catch (InvalidSyntaxException e) {
                OldStylePluginTests.fail((String)"Failed to create filter.", (Throwable)e);
            }
            OldStylePluginTests.assertTrue((String)("Did not match requirement: " + req + ": against: " + matchAttributes), (boolean)f.matches(matchAttributes));
            OldStylePluginTests.assertFalse((String)("Unexpected match requirement: " + req + ": against: " + matchAttributes), (boolean)f.matches(noMatchAttributes));
            String resolution = (String)req.getDirectives().get("resolution");
            if (resolution == null) {
                resolution = "mandatory";
            }
            if ((visibility = (String)req.getDirectives().get("visibility")) == null) {
                visibility = "private";
            }
            if (index == 6) {
                OldStylePluginTests.assertEquals((String)("Wrong visibility: " + req), (String)"reexport", (String)visibility);
            } else {
                OldStylePluginTests.assertEquals((String)("Wrong visibility: " + req), (String)"private", (String)visibility);
            }
            if (index == 7) {
                OldStylePluginTests.assertEquals((String)("Wrong resolution: " + req), (String)"optional", (String)resolution);
                continue;
            }
            OldStylePluginTests.assertEquals((String)("Wrong resolution: " + req), (String)"mandatory", (String)resolution);
        }
    }

    public void testExportSinglePackage() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.c";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, false);
        OldStylePluginTests.assertTrue((String)"Did not expect any requirements.", (boolean)revision.getDeclaredRequirements(null).isEmpty());
        List packages = revision.getDeclaredCapabilities("osgi.wiring.package");
        OldStylePluginTests.assertEquals((String)("Wrong number of exports: " + packages), (int)1, (int)packages.size());
        OldStylePluginTests.assertEquals((String)"Wrong package name.", (Object)(String.valueOf(pluginName) + ".exported"), ((BundleCapability)packages.iterator().next()).getAttributes().get("osgi.wiring.package"));
    }

    public void testExportAllPackage() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.d";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, false);
        OldStylePluginTests.assertTrue((String)"Did not expect any requirements.", (boolean)revision.getDeclaredRequirements(null).isEmpty());
        List packages = revision.getDeclaredCapabilities("osgi.wiring.package");
        OldStylePluginTests.assertEquals((String)("Wrong number of exports: " + packages), (int)4, (int)packages.size());
        Iterator iPackages = packages.iterator();
        OldStylePluginTests.assertEquals((String)"Wrong package name.", (Object)".", ((BundleCapability)iPackages.next()).getAttributes().get("osgi.wiring.package"));
        OldStylePluginTests.assertEquals((String)"Wrong package name.", (Object)pluginName, ((BundleCapability)iPackages.next()).getAttributes().get("osgi.wiring.package"));
        OldStylePluginTests.assertEquals((String)"Wrong package name.", (Object)(String.valueOf(pluginName) + ".exported"), ((BundleCapability)iPackages.next()).getAttributes().get("osgi.wiring.package"));
        OldStylePluginTests.assertEquals((String)"Wrong package name.", (Object)(String.valueOf(pluginName) + ".exported.sub"), ((BundleCapability)iPackages.next()).getAttributes().get("osgi.wiring.package"));
    }

    public void testActivator() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.e";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, false);
        try {
            bundle.start();
            Collection testServices = this.getContext().getServiceReferences(Object.class, "(bundle-symbolic-name=" + bundle.getSymbolicName() + ")");
            OldStylePluginTests.assertFalse((String)"Did not find registered service.", (boolean)testServices.isEmpty());
        }
        catch (BundleException e) {
            OldStylePluginTests.fail((String)"Failed to start bundle.", (Throwable)e);
        }
        catch (InvalidSyntaxException e) {
            OldStylePluginTests.fail((String)"Failed to create filter.", (Throwable)e);
        }
    }

    public void testExtensionSingleton() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.f";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, true);
    }

    public void testFragment() {
        if (!this.compatPluginInstalled) {
            return;
        }
        String pluginName = "test.plugins.g";
        Version pluginVersion = Version.parseVersion((String)"1.0.0");
        Bundle bundle = this.installPlugin(pluginName, false);
        BundleRevision revision = (BundleRevision)bundle.adapt(BundleRevision.class);
        this.assertIdentity(revision, pluginName, pluginVersion, false);
        OldStylePluginTests.assertTrue((String)"revision is not a fragment.", ((revision.getTypes() & 1) != 0 ? 1 : 0) != 0);
        List reqs = revision.getDeclaredRequirements("osgi.wiring.host");
        OldStylePluginTests.assertEquals((String)"Wrong number of host requirements.", (int)1, (int)reqs.size());
        BundleRequirement req = (BundleRequirement)reqs.iterator().next();
        HashMap<String, String> matchAttributes = new HashMap<String, String>();
        HashMap<String, String> noMatchAttributes = new HashMap<String, String>();
        matchAttributes.put("osgi.wiring.host", "x");
        noMatchAttributes.put("osgi.wiring.host", "x");
        Version match = Version.parseVersion((String)"1.1");
        Version noMatch = Version.parseVersion((String)"2.0");
        matchAttributes.put("bundle-version", (String)match);
        noMatchAttributes.put("bundle-version", (String)noMatch);
        Filter f = null;
        try {
            f = this.getContext().createFilter((String)req.getDirectives().get("filter"));
        }
        catch (InvalidSyntaxException e) {
            OldStylePluginTests.fail((String)"Failed to create filter.", (Throwable)e);
        }
        OldStylePluginTests.assertTrue((String)("Did not match requirement: " + req + ": against: " + matchAttributes), (boolean)f.matches(matchAttributes));
        OldStylePluginTests.assertFalse((String)("Unexpected match requirement: " + req + ": against: " + matchAttributes), (boolean)f.matches(noMatchAttributes));
    }

    private void assertIdentity(BundleRevision revision, String pluginName, Version pluginVersion, boolean isSingleton) {
        OldStylePluginTests.assertEquals((String)"Wrong symbolic name", (String)pluginName, (String)revision.getSymbolicName());
        OldStylePluginTests.assertEquals((String)"Wrong version.", (Object)pluginVersion, (Object)revision.getVersion());
        ArrayList capabilities = new ArrayList();
        capabilities.addAll(revision.getDeclaredCapabilities("osgi.identity"));
        capabilities.addAll(revision.getDeclaredCapabilities("osgi.wiring.bundle"));
        capabilities.addAll(revision.getDeclaredCapabilities("osgi.wiring.host"));
        int expectedNumCaps = (revision.getTypes() & 1) == 0 ? 3 : 1;
        OldStylePluginTests.assertEquals((String)("Wrong number of capabilities: " + capabilities), (int)expectedNumCaps, (int)capabilities.size());
        for (BundleCapability cap : capabilities) {
            String namespace = cap.getNamespace();
            String versionKey = "osgi.identity".equals(namespace) ? "version" : "bundle-version";
            Map attrs = cap.getAttributes();
            OldStylePluginTests.assertEquals((String)("Wrong name: " + namespace), (Object)pluginName, attrs.get(namespace));
            OldStylePluginTests.assertEquals((String)("Wrong version: " + namespace), (Object)pluginVersion, attrs.get(versionKey));
            String singletonDirective = (String)cap.getDirectives().get("singleton");
            singletonDirective = singletonDirective == null ? Boolean.FALSE.toString() : singletonDirective;
            OldStylePluginTests.assertEquals((String)"Wrong singleton directive.", (boolean)isSingleton, (boolean)Boolean.TRUE.toString().equals(singletonDirective));
        }
    }

    private Bundle installPlugin(String plugin, boolean expectedFailure) {
        try {
            return this.installer.installBundle(plugin);
        }
        catch (BundleException e) {
            if (!expectedFailure) {
                OldStylePluginTests.fail((String)"Failed to install plugin.", (Throwable)e);
            }
            return null;
        }
    }
}

