/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class TestCycle_002
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;
    BundleDescription bundle_3 = null;

    public TestCycle_002(String testName) {
        super(testName);
    }

    public void testTest_002() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.bundle_3 = this.create_bundle_3(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            TestCycle_002.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        BundleDescription[] requires = this.bundle_1.getResolvedRequires();
        TestCycle_002.assertNotNull((String)"requires array is unexpectedly null", (Object)requires);
        TestCycle_002.assertTrue((String)"requires array is unexpectedly empty", (requires.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < requires.length) {
            String requiresName = requires[i].getName();
            TestCycle_002.assertNotNull((String)"package name is null", (Object)requiresName);
            if (requiresName.equals("B")) {
                TestCycle_002.assertNotNull((String)"Require [B] is not wired when it should be ", (Object)requires[i]);
                this.assertEquals("Require [B] is wired incorrectly ", requires[i], this.bundle_2);
            } else if (requiresName.equals("C")) {
                TestCycle_002.assertNotNull((String)"Require [C] is not wired when it should be ", (Object)requires[i]);
                this.assertEquals("Require [C] is wired incorrectly ", requires[i], this.bundle_3);
            }
            ++i;
        }
    }

    public void checkWiringState_2() {
        BundleDescription[] requires = this.bundle_2.getResolvedRequires();
        TestCycle_002.assertNotNull((String)"requires array is unexpectedly null", (Object)requires);
        TestCycle_002.assertTrue((String)"requires array is unexpectedly empty", (requires.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < requires.length) {
            String requiresName = requires[i].getName();
            TestCycle_002.assertNotNull((String)"package name is null", (Object)requiresName);
            if (requiresName.equals("A")) {
                TestCycle_002.assertNotNull((String)"Require [A] is not wired when it should be ", (Object)requires[i]);
                this.assertEquals("Require [A] is wired incorrectly ", requires[i], this.bundle_1);
            } else if (requiresName.equals("C")) {
                TestCycle_002.assertNotNull((String)"Require [C] is not wired when it should be ", (Object)requires[i]);
                this.assertEquals("Require [C] is wired incorrectly ", requires[i], this.bundle_3);
            }
            ++i;
        }
    }

    public void checkWiringState_3() {
        BundleDescription[] requires = this.bundle_3.getResolvedRequires();
        TestCycle_002.assertNotNull((String)"requires array is unexpectedly null", (Object)requires);
        TestCycle_002.assertTrue((String)"requires array is unexpectedly empty", (requires.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < requires.length) {
            String requiresName = requires[i].getName();
            TestCycle_002.assertNotNull((String)"package name is null", (Object)requiresName);
            if (requiresName.equals("A")) {
                TestCycle_002.assertNotNull((String)"Require [A] is not wired when it should be ", (Object)requires[i]);
                this.assertEquals("Require [A] is wired incorrectly ", requires[i], this.bundle_1);
            } else if (requiresName.equals("B")) {
                TestCycle_002.assertNotNull((String)"Require [B] is not wired when it should be ", (Object)requires[i]);
                this.assertEquals("Require [B] is wired incorrectly ", requires[i], this.bundle_2);
            }
            ++i;
        }
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
        this.checkWiringState_3();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        TestCycle_002.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        TestCycle_002.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_3);
        TestCycle_002.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        TestCycle_002.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        TestCycle_002.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_2.isResolved());
        TestCycle_002.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_3.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "A");
        ((Dictionary)dictionary_1).put("Require-Bundle", "B, C");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            TestCycle_002.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "B");
        ((Dictionary)dictionary_2).put("Require-Bundle", "A, C");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            TestCycle_002.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_3(StateObjectFactory sof) {
        Properties dictionary_3 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_3).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_3).put("Bundle-SymbolicName", "C");
        ((Dictionary)dictionary_3).put("Require-Bundle", "A, B");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_3, "bundle_3", 3L);
        }
        catch (BundleException be) {
            TestCycle_002.fail((String)be.getMessage());
        }
        return bundle;
    }
}

