/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resolver;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.tests.services.resolver.AbstractStateTest;
import org.osgi.framework.BundleException;

public class TestGrouping_008
extends AbstractStateTest {
    BundleDescription bundle_1 = null;
    BundleDescription bundle_2 = null;
    BundleDescription bundle_3 = null;

    public TestGrouping_008(String testName) {
        super(testName);
    }

    public void testTest_008() {
        State state = this.buildEmptyState();
        StateObjectFactory sof = StateObjectFactory.defaultFactory;
        this.bundle_1 = this.create_bundle_1(sof);
        this.bundle_2 = this.create_bundle_2(sof);
        this.bundle_3 = this.create_bundle_3(sof);
        this.addBundlesToState_a(state);
        try {
            state.resolve();
        }
        catch (Throwable t) {
            TestGrouping_008.fail((String)("unexpected exception class=" + t.getClass().getName() + " message=" + t.getMessage()));
            return;
        }
        this.checkBundlesResolved_a();
        this.checkWiring_a();
    }

    public void checkWiringState_1() {
        BundleDescription[] requires = this.bundle_1.getResolvedRequires();
        TestGrouping_008.assertNotNull((String)"requires array is unexpectedly null", (Object)requires);
        TestGrouping_008.assertTrue((String)"requires array is unexpectedly empty", (requires.length > 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < requires.length) {
            BundleDescription bd = requires[i];
            String requiresName = bd.getName();
            TestGrouping_008.assertNotNull((String)"bundle name is null", (Object)requiresName);
            if (requiresName.equals("B")) {
                TestGrouping_008.assertNotNull((String)"Require [B] is not wired when it should be ", (Object)bd);
                this.assertEquals("Require [B] is wired incorrectly ", this.bundle_2, bd);
            }
            ++i;
        }
        ExportPackageDescription[] exports = this.bundle_1.getResolvedImports();
        TestGrouping_008.assertNotNull((String)"export array is unexpectedly null", (Object)exports);
        TestGrouping_008.assertTrue((String)"export array is unexpectedly empty", (exports.length > 0 ? 1 : 0) != 0);
        int i2 = 0;
        while (i2 < exports.length) {
            ExportPackageDescription exp = exports[i2];
            String exportPackageName = exp.getName();
            TestGrouping_008.assertNotNull((String)"package name is null", (Object)exportPackageName);
            if (exportPackageName.equals("p")) {
                TestGrouping_008.assertNotNull((String)"Package [p] is not wired when it should be ", (Object)exp.getExporter());
                this.assertEquals("Package [p] is wired incorrectly ", this.bundle_3, exp.getExporter());
            }
            ++i2;
        }
    }

    public void checkWiringState_2() {
    }

    public void checkWiringState_3() {
    }

    public void checkWiring_a() {
        this.checkWiringState_1();
        this.checkWiringState_2();
        this.checkWiringState_3();
    }

    public void addBundlesToState_a(State state) {
        boolean added = false;
        added = state.addBundle(this.bundle_1);
        TestGrouping_008.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_2);
        TestGrouping_008.assertTrue((String)"failed to add bundle ", (boolean)added);
        added = state.addBundle(this.bundle_3);
        TestGrouping_008.assertTrue((String)"failed to add bundle ", (boolean)added);
    }

    public void checkBundlesResolved_a() {
        TestGrouping_008.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_1.isResolved());
        TestGrouping_008.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_2.isResolved());
        TestGrouping_008.assertTrue((String)"unexpected bundle resolution state", (boolean)this.bundle_3.isResolved());
    }

    public BundleDescription create_bundle_1(StateObjectFactory sof) {
        Properties dictionary_1 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_1).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_1).put("Bundle-SymbolicName", "A");
        ((Dictionary)dictionary_1).put("Require-Bundle", "B");
        ((Dictionary)dictionary_1).put("Import-Package", "p");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_1, "bundle_1", 1L);
        }
        catch (BundleException be) {
            TestGrouping_008.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_2(StateObjectFactory sof) {
        Properties dictionary_2 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_2).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_2).put("Bundle-SymbolicName", "B");
        ((Dictionary)dictionary_2).put("Export-Package", "p");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_2, "bundle_2", 2L);
        }
        catch (BundleException be) {
            TestGrouping_008.fail((String)be.getMessage());
        }
        return bundle;
    }

    public BundleDescription create_bundle_3(StateObjectFactory sof) {
        Properties dictionary_3 = new Properties();
        BundleDescription bundle = null;
        ((Dictionary)dictionary_3).put("Bundle-ManifestVersion", "2");
        ((Dictionary)dictionary_3).put("Bundle-SymbolicName", "C");
        ((Dictionary)dictionary_3).put("Export-Package", "p; version=2");
        try {
            bundle = sof.createBundleDescription((Dictionary)dictionary_3, "bundle_3", 3L);
        }
        catch (BundleException be) {
            TestGrouping_008.fail((String)be.getMessage());
        }
        return bundle;
    }
}

