/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.tests.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.osgi.tests.resource.AbstractResourceTest;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

public class BasicTest
extends AbstractResourceTest {
    private Bundle tb1;
    private Bundle tb2;
    private Bundle tb3;
    private Bundle tb4;
    private Bundle tf1;
    private Bundle tf2;

    public static Test suite() {
        return new TestSuite(BasicTest.class);
    }

    public BasicTest(String name) {
        super(name);
    }

    public void testRequirementMatches() throws Exception {
        Bundle tb5 = this.installer.installBundle("resource.tb5");
        Resource requirer = (Resource)tb5.adapt(BundleRevision.class);
        Capability capability1 = this.createCapability1();
        List requirements = requirer.getRequirements(capability1.getNamespace());
        this.assertRequirements(requirements, 3);
        Requirement requirement1 = (Requirement)requirements.get(0);
        this.assertRequirementMatches(requirement1, capability1);
        Capability capability2 = this.createCapability2();
        this.assertNotRequirementMatches(requirement1, capability2);
        Requirement requirement2 = (Requirement)requirements.get(1);
        this.assertAttribute(requirement2, "b", "a");
        this.assertRequirementMatches(requirement2, capability1);
        Requirement requirement3 = (Requirement)requirements.get(2);
        this.assertAttribute(requirement3, "b", "a");
        this.assertAttribute(requirement3, "bar", "foo");
        this.assertFilterDirective(requirement3);
        this.assertRequirementMatches(requirement3, capability1);
        Requirement requirement4 = (Requirement)requirements.get(3);
        this.assertAttribute(requirement4, "a", "b");
        this.assertFilterDirective(requirement4);
        this.assertNotRequirementMatches(requirement4, capability1);
        requirements = requirer.getRequirements(capability2.getNamespace());
        this.assertRequirements(requirements, 0);
        Requirement requirement5 = (Requirement)requirements.get(0);
        this.assertAttribute(requirement5, "bar", "foo");
        this.assertAttribute(requirement5, "y", "x");
        this.assertFilterDirective(requirement5);
        this.assertDirective(requirement5, "mandatory", "foo,x");
        this.assertRequirementMatches(requirement5, capability2);
    }

    public void testIdentity() throws Exception {
        this.tb1 = this.installer.installBundle("resource.tb1");
        this.tb2 = this.installer.installBundle("resource.tb2");
        this.tb3 = this.installer.installBundle("resource.tb3");
        this.tb4 = this.installer.installBundle("resource.tb4");
        this.tf1 = this.installer.installBundle("resource.tf1");
        this.tf2 = this.installer.installBundle("resource.tf2");
        this.installer.resolveBundles(null);
        this.tb1.start();
        this.tb2.start();
        this.tb3.start();
        this.tb4.start();
        BasicTest.assertEquals((String)"tf1 not resolved", (int)this.tf1.getState(), (int)4);
        BasicTest.assertEquals((String)"tf2 not resolved", (int)this.tf2.getState(), (int)4);
        this.assertTb1();
        this.assertTb2();
        this.assertTb3();
        this.assertTb4();
        this.assertTf1();
        this.assertTf2();
    }

    private void assertTb1() {
        BundleRevision revision = (BundleRevision)this.tb1.adapt(BundleRevision.class);
        String symbolicName = revision.getSymbolicName();
        this.assertSymbolicName("resource.tb1", symbolicName);
        Version version = revision.getVersion();
        this.assertVersion("1.0.0", version);
        String type = this.getType(revision);
        this.assertType("osgi.bundle", type);
        HashMap<String, String> arbitraryAttrs = new HashMap<String, String>();
        arbitraryAttrs.put("attr1", "a1");
        arbitraryAttrs.put("attr2", "a2");
        HashMap<String, String> arbitraryDirs = new HashMap<String, String>();
        arbitraryDirs.put("dir1", "d1");
        arbitraryDirs.put("dir2", "d2");
        Capability capability = this.getIdentityCapability(revision);
        this.assertIdentityCapability(capability, symbolicName, version, type, arbitraryAttrs, arbitraryDirs);
        BundleRevision resource = revision;
        capability = this.getIdentityCapability((Resource)resource);
        this.assertIdentityCapability(capability, symbolicName, version, type, arbitraryAttrs, arbitraryDirs);
        BundleWiring wiring = (BundleWiring)this.tb1.adapt(BundleWiring.class);
        capability = this.getIdentityCapability(wiring);
        this.assertIdentityCapability(capability, symbolicName, version, type, arbitraryAttrs, arbitraryDirs);
        List wires = wiring.getProvidedWires("osgi.identity");
        this.assertWires(wires, 1);
        Wire wire = (Wire)wires.get(0);
        BundleRevision requirer = (BundleRevision)this.tb3.adapt(BundleRevision.class);
        Requirement requirement = this.getIdentityRequirement(requirer, 1);
        this.assertIdentityWire(wire, capability, (Resource)revision, requirement, (Resource)requirer);
        wires = wiring.getRequiredWires("osgi.identity");
        this.assertWires(wires, 1);
        wire = (Wire)wires.get(0);
        BundleRevision provider = (BundleRevision)this.tb4.adapt(BundleRevision.class);
        capability = this.getIdentityCapability(provider);
        requirement = this.getIdentityRequirement((BundleRevision)this.tf1.adapt(BundleRevision.class), 0);
        this.assertIdentityWire(wire, capability, (Resource)provider, requirement, (Resource)revision);
    }

    private void assertTb2() {
        final BundleRevision revision = (BundleRevision)this.tb2.adapt(BundleRevision.class);
        this.assertNotIdentityCapability(new CapabilityProvider(){

            @Override
            public List getCapabilities(String namespace) {
                return revision.getDeclaredCapabilities(namespace);
            }
        });
        BundleRevision resource = revision;
        this.assertNotIdentityCapability(new CapabilityProvider((Resource)resource){
            private final /* synthetic */ Resource val$resource;
            {
                this.val$resource = resource;
            }

            @Override
            public List getCapabilities(String namespace) {
                return this.val$resource.getCapabilities(namespace);
            }
        });
        final BundleWiring wiring = (BundleWiring)this.tb2.adapt(BundleWiring.class);
        this.assertNotIdentityCapability(new CapabilityProvider(){

            @Override
            public List getCapabilities(String namespace) {
                return wiring.getCapabilities(namespace);
            }
        });
    }

    private void assertTb3() {
        BundleRevision revision = (BundleRevision)this.tb3.adapt(BundleRevision.class);
        String symbolicName = revision.getSymbolicName();
        this.assertSymbolicName("resource.tb3", symbolicName);
        Version version = revision.getVersion();
        this.assertVersion("1.0.0", version);
        String type = this.getType(revision);
        this.assertType("osgi.bundle", type);
        Capability capability = this.getIdentityCapability(revision);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleRevision resource = revision;
        capability = this.getIdentityCapability((Resource)resource);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleWiring wiring = (BundleWiring)this.tb3.adapt(BundleWiring.class);
        capability = this.getIdentityCapability(wiring);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List wires = wiring.getRequiredWires("osgi.identity");
        this.assertWires(wires, 2);
        Wire wire = (Wire)wires.get(1);
        Requirement requirement = this.getIdentityRequirement(revision, 1);
        BundleRevision provider = (BundleRevision)this.tb1.adapt(BundleRevision.class);
        capability = this.getIdentityCapability(provider);
        this.assertIdentityWire(wire, capability, (Resource)provider, requirement, (Resource)revision);
        wire = (Wire)wires.get(0);
        requirement = this.getIdentityRequirement(revision, 0);
        provider = (BundleRevision)this.tf1.adapt(BundleRevision.class);
        capability = this.getIdentityCapability(provider);
        this.assertIdentityWire(wire, capability, (Resource)provider, requirement, (Resource)revision);
    }

    private void assertTb4() {
        BundleRevision revision = (BundleRevision)this.tb4.adapt(BundleRevision.class);
        String symbolicName = revision.getSymbolicName();
        this.assertSymbolicName("resource.tb4", symbolicName);
        Version version = revision.getVersion();
        this.assertVersion("1.0.0", version);
        String type = this.getType(revision);
        this.assertType("osgi.bundle", type);
        Capability capability = this.getIdentityCapability(revision);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleRevision resource = revision;
        capability = this.getIdentityCapability((Resource)resource);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleWiring wiring = (BundleWiring)this.tb4.adapt(BundleWiring.class);
        capability = this.getIdentityCapability(wiring);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List wires = wiring.getProvidedWires("osgi.identity");
        this.assertWires(wires, 1);
        Wire wire = (Wire)wires.get(0);
        BundleRevision requirer = (BundleRevision)this.tb1.adapt(BundleRevision.class);
        Requirement requirement = this.getIdentityRequirement((BundleRevision)this.tf1.adapt(BundleRevision.class), 0);
        this.assertIdentityWire(wire, capability, (Resource)revision, requirement, (Resource)requirer);
    }

    private void assertTf1() {
        BundleRevision revision = (BundleRevision)this.tf1.adapt(BundleRevision.class);
        String symbolicName = revision.getSymbolicName();
        this.assertSymbolicName("resource.tf1", symbolicName);
        Version version = revision.getVersion();
        this.assertVersion("1.0.0", version);
        String type = this.getType(revision);
        this.assertType("osgi.fragment", type);
        Capability capability = this.getIdentityCapability(revision);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleRevision resource = revision;
        capability = this.getIdentityCapability((Resource)resource);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleWiring wiring = (BundleWiring)this.tf1.adapt(BundleWiring.class);
        capability = this.getIdentityCapability(wiring);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List wires = wiring.getProvidedWires("osgi.identity");
        this.assertWires(wires, 1);
        Wire wire = (Wire)wires.get(0);
        BundleRevision requirer = (BundleRevision)this.tb3.adapt(BundleRevision.class);
        Requirement requirement = this.getIdentityRequirement(requirer, 0);
        this.assertIdentityWire(wire, capability, (Resource)revision, requirement, (Resource)requirer);
    }

    private void assertTf2() {
        BundleRevision revision = (BundleRevision)this.tf2.adapt(BundleRevision.class);
        String symbolicName = revision.getSymbolicName();
        this.assertSymbolicName("resource.tf2", symbolicName);
        Version version = revision.getVersion();
        this.assertVersion("0.0.0", version);
        String type = this.getType(revision);
        this.assertType("osgi.fragment", type);
        Capability capability = this.getIdentityCapability(revision);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleRevision resource = revision;
        capability = this.getIdentityCapability((Resource)resource);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        BundleWiring wiring = (BundleWiring)this.tf2.adapt(BundleWiring.class);
        capability = this.getIdentityCapability(wiring);
        this.assertIdentityCapability(capability, symbolicName, version, type, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List wires = wiring.getProvidedWires("osgi.identity");
        this.assertWires(wires, 0);
    }

    private void assertAttribute(Requirement requirement, String name, Object expected) {
        BasicTest.assertEquals((String)("Wrong attribute: " + name), (Object)expected, requirement.getAttributes().get(name));
    }

    private void assertCapabilities(List capabilities, int size) {
        BasicTest.assertNotNull((String)"Null capabilities", (Object)capabilities);
        BasicTest.assertEquals((String)"Wrong number of capabilities", (int)size, (int)capabilities.size());
    }

    private void assertDirective(Requirement requirement, String name, String expected) {
        BasicTest.assertEquals((String)"Wrong directive", (String)expected, (String)((String)requirement.getDirectives().get(name)));
    }

    private void assertFilterDirective(Requirement requirement) {
        BasicTest.assertNotNull((String)"Missing filter directive", requirement.getDirectives().get("filter"));
    }

    private void assertIdentityCapability(Capability capability, String symbolicName, Version version, String type, Map arbitraryAttrs, Map arbitraryDirs) {
        BasicTest.assertEquals((String)"Wrong namespace", (String)"osgi.identity", (String)capability.getNamespace());
        BasicTest.assertEquals((String)"Wrong number of attributes", (int)(3 + arbitraryAttrs.size()), (int)capability.getAttributes().size());
        this.assertSymbolicName(symbolicName, (String)capability.getAttributes().get("osgi.identity"));
        this.assertVersion(version, (Version)capability.getAttributes().get("version"));
        this.assertType(type, (String)capability.getAttributes().get("type"));
        Map attributes = capability.getAttributes();
        for (Map.Entry entry : arbitraryAttrs.entrySet()) {
            BasicTest.assertEquals((String)("Wrong attribute: " + entry.getKey()), entry.getValue(), attributes.get(entry.getKey()));
        }
        Map directives = capability.getDirectives();
        for (Map.Entry entry : arbitraryDirs.entrySet()) {
            BasicTest.assertEquals((String)("Wrong directive: " + entry.getKey()), entry.getValue(), directives.get(entry.getKey()));
        }
    }

    private void assertIdentityWire(Wire wire, Capability capability, Resource provider, Requirement requirement, Resource requirer) {
        BasicTest.assertEquals((String)"Wrong capability", (Object)capability, (Object)wire.getCapability());
        BasicTest.assertEquals((String)"Wrong provider", (Object)provider, (Object)wire.getProvider());
        BasicTest.assertEquals((String)"Wrong requirement", (Object)requirement, (Object)wire.getRequirement());
        BasicTest.assertEquals((String)"Wrong requirer", (Object)requirer, (Object)wire.getRequirer());
        this.assertRequirementMatches(requirement, capability);
    }

    private void assertNotIdentityCapability(CapabilityProvider provider) {
        List capabilities = provider.getCapabilities("osgi.identity");
        this.assertCapabilities(capabilities, 0);
    }

    private void assertNotRequirementMatches(Requirement requirement, Capability capability) {
        if (!(requirement instanceof BundleRequirement) || !(capability instanceof BundleCapability)) {
            return;
        }
        BasicTest.assertFalse((String)"Requirement matches capability", (boolean)((BundleRequirement)requirement).matches((BundleCapability)capability));
    }

    private void assertNotNull(Capability capability) {
        Assert.assertNotNull((String)"Null capability", (Object)capability);
    }

    private void assertNotNull(Requirement requirement) {
        Assert.assertNotNull((String)"Null requirement", (Object)requirement);
    }

    private void assertRequirementMatches(Requirement requirement, Capability capability) {
        if (!(requirement instanceof BundleRequirement) || !(capability instanceof BundleCapability)) {
            return;
        }
        BasicTest.assertTrue((String)"Requirement does not match capability", (boolean)((BundleRequirement)requirement).matches((BundleCapability)capability));
    }

    private void assertRequirements(List requirements, int index) {
        BasicTest.assertNotNull((String)"Null requirements", (Object)requirements);
        BasicTest.assertTrue((String)"Wrong number of requirements", (requirements.size() > index ? 1 : 0) != 0);
    }

    private void assertSymbolicName(String expected, String actual) {
        BasicTest.assertEquals((String)"Wrong symbolic name", (String)expected, (String)actual);
    }

    private void assertType(String expected, String actual) {
        BasicTest.assertEquals((String)"Wrong type", (String)expected, (String)actual);
    }

    private void assertVersion(String expected, Version actual) {
        this.assertVersion(Version.parseVersion((String)expected), actual);
    }

    private void assertVersion(Version expected, Version actual) {
        BasicTest.assertEquals((String)"Wrong version", (Object)expected, (Object)actual);
    }

    private void assertWires(List wires, int size) {
        BasicTest.assertNotNull((String)"Null wires", (Object)wires);
        BasicTest.assertEquals((String)"Wrong number of wires", (int)size, (int)wires.size());
    }

    private Capability createCapability1() {
        String namespace = "capability.1";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("a", "b");
        return new BasicCapability(namespace, attributes);
    }

    private Capability createCapability2() {
        String namespace = "capability.2";
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("foo", "bar");
        attributes.put("x", "y");
        HashMap<String, String> directives = new HashMap<String, String>();
        directives.put("mandatory", "foo,x");
        return new BasicCapability(namespace, attributes, directives);
    }

    private Capability getIdentityCapability(BundleRevision revision) {
        List capabilities = revision.getDeclaredCapabilities("osgi.identity");
        this.assertCapabilities(capabilities, 1);
        Capability capability = (Capability)capabilities.get(0);
        this.assertNotNull(capability);
        return capability;
    }

    private Capability getIdentityCapability(BundleWiring wiring) {
        List capabilities = wiring.getCapabilities("osgi.identity");
        this.assertCapabilities(capabilities, 1);
        Capability capability = (Capability)capabilities.get(0);
        this.assertNotNull(capability);
        return capability;
    }

    private Capability getIdentityCapability(Resource resource) {
        List capabilities = resource.getCapabilities("osgi.identity");
        this.assertCapabilities(capabilities, 1);
        Capability capability = (Capability)capabilities.get(0);
        this.assertNotNull(capability);
        return capability;
    }

    private Requirement getIdentityRequirement(BundleRevision revision, int index) {
        List requirements = revision.getDeclaredRequirements("osgi.identity");
        this.assertRequirements(requirements, index);
        Requirement requirement = (Requirement)requirements.get(index);
        this.assertNotNull(requirement);
        return requirement;
    }

    private String getType(BundleRevision revision) {
        return (revision.getTypes() & 1) == 0 ? "osgi.bundle" : "osgi.fragment";
    }

    static class BasicCapability
    implements Capability {
        private final Map attributes;
        private final Map directives;
        private final String namespace;

        public BasicCapability(String namespace) {
            this(namespace, Collections.EMPTY_MAP);
        }

        public BasicCapability(String namespace, Map attributes) {
            this(namespace, attributes, Collections.EMPTY_MAP);
        }

        public BasicCapability(String namespace, Map attributes, Map directives) {
            this.namespace = namespace;
            this.attributes = attributes;
            this.directives = directives;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public Map getDirectives() {
            return this.directives;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public Resource getResource() {
            return null;
        }
    }

    private static interface CapabilityProvider {
        public List getCapabilities(String var1);
    }
}

